(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[    236707,       6289]
NotebookOptionsPosition[    218463,       5988]
NotebookOutlinePosition[    218889,       6005]
CellTagsIndexPosition[    218846,       6002]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilGebra`"}]], "Input",
 CellChangeTimes->{{3.9352282232521267`*^9, 3.935228231282587*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"1b1a1a17-883a-ba40-b720-b30927f5d099"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilGebra cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
03/09/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9352282319192295`*^9, 3.9352285171666107`*^9, 
  3.935230555479435*^9, 3.935313584853344*^9, 3.9358271050438633`*^9, 
  3.936096234307955*^9, 3.936173131147661*^9, 3.9367751046587315`*^9, 
  3.9603888543566628`*^9, 3.9603888968170567`*^9, 3.9712641770715113`*^9, 
  3.971340807306677*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[8]:=",ExpressionUUID->"aba832aa-6ad4-4700-8cb5-c3bf99825b0f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejercicios algebraicos: transpuesta, suma, resta, escalar, producto y \
potenciaci\[OAcute]n\
\>", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037337691245*^9}, {
  3.960373576570084*^9, 3.9603735787774887`*^9}, {3.9603736169876842`*^9, 
  3.960373624391457*^9}, {3.971268805393935*^9, 
  3.971268806415683*^9}},ExpressionUUID->"73ec55cb-5314-4876-981e-\
95cf93dc5c52"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A", "=", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          RowBox[{"-", "1"}], "1", "2", 
          RowBox[{"-", "2"}]},
         {
          RowBox[{"-", "1"}], "0", "2", "2"},
         {"0", "2", "0", "0"},
         {"2", 
          RowBox[{"-", "2"}], 
          RowBox[{"-", "1"}], 
          RowBox[{"-", "2"}]}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{"B", "=", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"2", 
          RowBox[{"-", "2"}], "0", "1"},
         {"0", "1", "2", "2"},
         {"1", 
          RowBox[{"-", 
           FractionBox["1", "2"]}], 
          RowBox[{"-", "1"}], 
          RowBox[{"-", "1"}]},
         {
          FractionBox["1", "2"], "2", "0", "0"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{"c", "=", 
     TagBox[
      TagBox[
       RowBox[{"(", "\[NoBreak]", GridBox[{
          {"1", "0", 
           FractionBox["1", "2"], "1"},
          {"2", 
           RowBox[{"-", "1"}], "0", "2"},
          {"0", "0", "0", 
           FractionBox["1", "2"]},
          {
           RowBox[{"-", 
            FractionBox["1", "2"]}], "1", 
           RowBox[{"-", "1"}], "1"}
         },
         GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.7]}, 
             Offset[0.27999999999999997`]}, "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}}], "\[NoBreak]", ")"}],
       Function[BoxForm`e$, 
        MatrixForm[BoxForm`e$]]],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{"d", "=", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          RowBox[{"-", "1"}], 
          RowBox[{"-", "2"}], 
          RowBox[{"-", "2"}], 
          RowBox[{"-", "1"}]},
         {"0", "0", "0", "0"},
         {
          RowBox[{"-", 
           FractionBox["1", "2"]}], 
          RowBox[{"-", "2"}], 
          FractionBox["1", "2"], 
          RowBox[{"-", "1"}]},
         {
          RowBox[{"-", "1"}], "1", "1", "0"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}]}], "}"}], ";"}]], "Input",
 CellChangeTimes->{{3.960390882206438*^9, 3.9603909292756767`*^9}, {
  3.960391168301035*^9, 3.960391192191601*^9}},
 CellLabel->"In[14]:=",ExpressionUUID->"1163d8e6-8c6d-f043-932a-8cd79df75dac"],

Cell[TextData[{
 "1. ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "A"}], " ", "-", " ", 
        RowBox[{"B", "^", "T"}]}], ")"}], "^", "2"}], "]"}], "T"], 
   TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "e8886e14-cba9-fb41-bf22-037c91359262"],
 "+(CD)^2"
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
  3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
  3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
  3.9603905022612*^9, 
  3.96039050266572*^9}},ExpressionUUID->"5d9fd97f-82c1-2940-8440-\
77adea4c40a3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "A"}], "-", 
       RowBox[{"Transpose", "[", "B", "]"}]}], ",", "2"}], "]"}], "]"}], "+", 
   RowBox[{"MatrixPower", "[", 
    RowBox[{
     RowBox[{"c", ".", "d"}], ",", "2"}], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.960390648733675*^9, 3.960390721758194*^9}, {
  3.9603907825882053`*^9, 3.9603907985580635`*^9}, {3.9603908324179993`*^9, 
  3.9603908340606537`*^9}, {3.9603909377052956`*^9, 3.960390940735285*^9}},
 CellLabel->"In[15]:=",ExpressionUUID->"3f0c3235-0883-dd4b-942b-fe864283492b"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["255", "16"], 
      FractionBox["65", "8"], 
      FractionBox["49", "16"], 
      RowBox[{"-", 
       FractionBox["151", "8"]}]},
     {"41", "1", "3", "41"},
     {
      FractionBox["27", "8"], 
      RowBox[{"-", 
       FractionBox["7", "4"]}], 
      FractionBox["77", "8"], 
      RowBox[{"-", 
       FractionBox["61", "4"]}]},
     {
      FractionBox["93", "4"], 
      RowBox[{"-", 
       FractionBox["45", "4"]}], 
      RowBox[{"-", "1"}], 
      RowBox[{"-", 
       FractionBox["61", "4"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9603907252465687`*^9, {3.9603908232011566`*^9, 3.960390834834154*^9}, {
   3.9603909322894955`*^9, 3.960390941378359*^9}, 3.960391202299082*^9, 
   3.971009281901682*^9},
 CellLabel->
  "Out[15]//MatrixForm=",ExpressionUUID->"6d7295d2-bca7-4155-a57c-\
82fa663009c7"]
}, Open  ]],

Cell["2. (C^T D+D^T C)^-1-1/2BA", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905060148983`*^9, 3.9603905113179607`*^9}, 3.9603913863249435`*^9, 
   3.960391435644375*^9, {3.9603914740611916`*^9, 
   3.960391475741535*^9}},ExpressionUUID->"b3e7a6bf-26ee-ca44-9cb7-\
00d7dc808c87"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Inverse", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Transpose", "[", "c", "]"}], ".", "d"}], "+", 
     RowBox[{
      RowBox[{"Transpose", "[", "d", "]"}], ".", "c"}]}], "]"}], "-", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"B", ".", "A"}]}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.9603913206265965`*^9, 3.960391403921919*^9}, {
  3.960391439413563*^9, 3.9603914936171474`*^9}},
 CellLabel->"In[16]:=",ExpressionUUID->"6464d608-c2a4-a747-854b-67744a2e8591"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["281", "529"]}], 
      FractionBox["290", "1587"], 
      FractionBox["1283", "3174"], 
      FractionBox["2333", "529"]},
     {
      RowBox[{"-", 
       FractionBox["4181", "3174"]}], 
      FractionBox["196", "529"], 
      RowBox[{"-", 
       FractionBox["82", "1587"]}], 
      FractionBox["305", "529"]},
     {
      FractionBox["7327", "6348"], 
      RowBox[{"-", 
       FractionBox["1751", "3174"]}], 
      RowBox[{"-", 
       FractionBox["2011", "1587"]}], 
      FractionBox["793", "1058"]},
     {
      FractionBox["1397", "2116"], 
      RowBox[{"-", 
       FractionBox["1425", "2116"]}], 
      RowBox[{"-", 
       FractionBox["2381", "1058"]}], 
      RowBox[{"-", 
       FractionBox["1075", "1058"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.9603914296340427`*^9, 3.960391494547653*^9}, 
   3.97100934776795*^9},
 CellLabel->
  "Out[16]//MatrixForm=",ExpressionUUID->"fa2034a9-c30c-4240-a26c-\
e86d9ad27e21"]
}, Open  ]],

Cell[TextData[{
 "3.  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"A", "+", "B"}], ")"}], "^", "T"}], "-", 
      RowBox[{"3", "C"}]}], "]"}], 
    RowBox[{"D", "^", "3"}]}], TraditionalForm]],
  FormatType->TraditionalForm,ExpressionUUID->
  "d5d5786d-6138-4844-bfd3-b126769847ae"],
 "+(A+B)^-1"
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
  3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
  3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
  3.9603905151276245`*^9, 
  3.960390521103571*^9}},ExpressionUUID->"9fb5e2b2-82b5-914f-ad87-\
164bba40d3c0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"A", "+", "B"}], "]"}], "-", 
      RowBox[{"3", "c"}]}], ")"}], ".", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{"d", ",", "3"}], "]"}]}], "+", 
   RowBox[{"Inverse", "[", 
    RowBox[{"A", "+", "B"}], "]"}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.9603915399643574`*^9, 3.960391600603752*^9}},
 CellLabel->"In[17]:=",ExpressionUUID->"dd4617cc-64a7-594e-b837-70bdbfa30872"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["3199", "240"], 
      FractionBox["643", "60"], 
      FractionBox["541", "80"], 
      FractionBox["179", "20"]},
     {
      FractionBox["4043", "80"], 
      FractionBox["1051", "20"], 
      FractionBox["1331", "80"], 
      FractionBox["729", "20"]},
     {
      RowBox[{"-", 
       FractionBox["35", "6"]}], 
      FractionBox["289", "24"], 
      RowBox[{"-", "4"}], 
      FractionBox["11", "4"]},
     {
      FractionBox["5", "2"], 
      FractionBox["91", "4"], 
      RowBox[{"-", "8"}], "11"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.96039159264353*^9, 3.960391601374176*^9}, 
   3.971009395260365*^9},
 CellLabel->
  "Out[17]//MatrixForm=",ExpressionUUID->"96ab0b0b-88a6-4fc4-8642-\
aa2193c7df26"]
}, Open  ]],

Cell["4. (2A+B^T)^4-(C-A)^T(D+A)", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905260918083`*^9, 3.9603905326276264`*^9}, 
   3.9603917954032936`*^9},ExpressionUUID->"0e4c56aa-cc25-6d4c-99af-\
0a898ddbfddb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatrixPower", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "A"}], "+", 
      RowBox[{"Transpose", "[", "B", "]"}]}], ",", "4"}], "]"}], "-", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"c", "-", "A"}], "]"}], ".", 
    RowBox[{"(", 
     RowBox[{"d", "+", "A"}], ")"}]}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.9603917281174164`*^9, 3.9603917900449696`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"71bb1fbd-99d6-7948-8291-ac0dd12c4e9e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["4247", "4"], 
      RowBox[{"-", "969"}], 
      RowBox[{"-", 
       FractionBox["2695", "4"]}], 
      RowBox[{"-", "725"}]},
     {"342", "1028", 
      RowBox[{"-", "716"}], 
      RowBox[{"-", "643"}]},
     {
      RowBox[{"-", "353"}], 
      RowBox[{"-", 
       FractionBox["2019", "2"]}], "1376", 
      RowBox[{"-", 
       FractionBox["637", "2"]}]},
     {
      RowBox[{"-", 
       FractionBox["1491", "4"]}], 
      RowBox[{"-", "439"}], 
      FractionBox["825", "4"], 
      FractionBox["4327", "4"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.960391769982649*^9, 3.9603918102080727`*^9}, 
   3.97100943909494*^9},
 CellLabel->
  "Out[18]//MatrixForm=",ExpressionUUID->"d503245f-a9df-4685-b62e-\
a38827061bbb"]
}, Open  ]],

Cell["5. [(AB)^T+(C^TA^T)+(D+B)^T-C^T-B^T]^-1\[LineSeparator]", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
  3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
  3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
  3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
  3.960391971892025*^9}},ExpressionUUID->"70e1f69a-8078-1d47-9fe8-\
a991ce1d69cc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", 
   RowBox[{
    RowBox[{"Transpose", "[", 
     RowBox[{"A", ".", "B"}], "]"}], "+", 
    RowBox[{
     RowBox[{"Transpose", "[", "c", "]"}], ".", 
     RowBox[{"Transpose", "[", "A", "]"}]}], "+", 
    RowBox[{"Transpose", "[", 
     RowBox[{"d", "+", "B"}], "]"}], "-", 
    RowBox[{"Transpose", "[", "c", "]"}], "-", 
    RowBox[{"Transpose", "[", "B", "]"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.9603918159522743`*^9, 3.9603919659851513`*^9}},
 CellLabel->"In[19]:=",ExpressionUUID->"0335171f-82d2-a84b-ac7e-deae03f2c138"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["943", "172"], 
      RowBox[{"-", 
       FractionBox["9", "43"]}], 
      RowBox[{"-", 
       FractionBox["161", "43"]}], 
      RowBox[{"-", 
       FractionBox["73", "172"]}]},
     {
      FractionBox["1017", "86"], 
      RowBox[{"-", 
       FractionBox["4", "43"]}], 
      RowBox[{"-", 
       FractionBox["320", "43"]}], 
      RowBox[{"-", 
       FractionBox["107", "86"]}]},
     {
      FractionBox["494", "43"], 
      RowBox[{"-", 
       FractionBox["6", "43"]}], 
      RowBox[{"-", 
       FractionBox["308", "43"]}], 
      RowBox[{"-", 
       FractionBox["48", "43"]}]},
     {
      FractionBox["7", "2"], "0", 
      RowBox[{"-", "2"}], 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.960391884872528*^9, 3.960391966750017*^9}, 
   3.971009492320043*^9},
 CellLabel->
  "Out[19]//MatrixForm=",ExpressionUUID->"2bf632cb-fc23-445f-805d-\
7109fc4ad741"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Resolver ecuaciones matriciales con o sin uso de la inversa", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.96037341740977*^9}, {
  3.960373582838707*^9, 3.960373583215248*^9}, {3.960373630954955*^9, 
  3.9603736455556297`*^9}, {3.971268817856449*^9, 
  3.971268818139889*^9}},ExpressionUUID->"83fea3e1-6bfe-4354-a81e-\
9fca04922cf3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"A", "=", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          RowBox[{"-", "3"}], 
          RowBox[{"-", "3"}], 
          FractionBox["1", "2"], "0"},
         {
          RowBox[{"-", "3"}], 
          RowBox[{"-", "3"}], 
          FractionBox["3", "2"], 
          RowBox[{"-", "1"}]},
         {"2", "1", "2", "1"},
         {
          FractionBox["1", "2"], "1", "2", "1"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{"B", "=", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"3", 
          RowBox[{"-", "2"}], 
          RowBox[{"-", "3"}], "1"},
         {"0", 
          RowBox[{"-", 
           FractionBox["3", "2"]}], "1", 
          RowBox[{"-", "1"}]},
         {
          RowBox[{"-", "1"}], 
          RowBox[{"-", 
           FractionBox["3", "2"]}], 
          RowBox[{"-", "3"}], 
          RowBox[{"-", "1"}]},
         {"0", 
          RowBox[{"-", 
           FractionBox["1", "2"]}], "0", "2"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{"c", "=", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {"0", 
          RowBox[{"-", 
           FractionBox["1", "3"]}], "3", 
          RowBox[{"-", 
           FractionBox["2", "3"]}]},
         {
          RowBox[{"-", "2"}], "0", 
          RowBox[{"-", "2"}], 
          RowBox[{"-", "3"}]},
         {
          RowBox[{"-", 
           FractionBox["1", "2"]}], "2", 
          RowBox[{"-", "1"}], "1"},
         {
          RowBox[{"-", "3"}], 
          RowBox[{"-", "1"}], "1", "0"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], ",", 
    RowBox[{"d", "=", 
     TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
         {
          FractionBox["1", "3"], "1", 
          RowBox[{"-", "2"}], 
          RowBox[{"-", 
           FractionBox["1", "3"]}]},
         {
          RowBox[{"-", "2"}], "0", "2", 
          RowBox[{"-", "2"}]},
         {"1", "1", "3", 
          RowBox[{"-", 
           FractionBox["2", "3"]}]},
         {"0", 
          RowBox[{"-", "1"}], "1", "0"}
        },
        GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.7]}, 
            Offset[0.27999999999999997`]}, "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}}], "\[NoBreak]", ")"}],
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}]}], "}"}], ";"}]], "Input",
 CellChangeTimes->{{3.971195633420754*^9, 3.9711956583661203`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"7285b796-c2d3-4e31-825c-f480b0853b2e"],

Cell["\<\
6. (A+X)^T(B-C)^-1=D^2
\[DoubleRightArrow]X=[D^2(B-C)]^T-A\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
  3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
  3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
  3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
  3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
  3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
  3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
  3.971264966870618*^9, 
  3.971264967392866*^9}},ExpressionUUID->"d21a102a-0ff7-406b-b46c-\
a40a29f64389"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{"MatrixPower", "[", 
      RowBox[{"d", ",", "2"}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{"B", "-", "c"}], ")"}]}], "]"}], "-", "A"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971196860831357*^9, 3.971196889721924*^9}, {
  3.971196942676775*^9, 3.971196953278734*^9}, {3.971264711961635*^9, 
  3.971264736114634*^9}, {3.971264847209186*^9, 3.971264871186878*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"864381ba-891d-46f6-b431-1f11980765a6"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["67", "6"]}], "5", 
      RowBox[{"-", 
       FractionBox["13", "3"]}], 
      FractionBox["29", "2"]},
     {
      FractionBox["772", "27"], 
      RowBox[{"-", 
       FractionBox["275", "9"]}], 
      RowBox[{"-", 
       FractionBox["757", "18"]}], 
      RowBox[{"-", 
       FractionBox["25", "3"]}]},
     {
      FractionBox["253", "9"], 
      RowBox[{"-", 
       FractionBox["55", "3"]}], 
      RowBox[{"-", 
       FractionBox["25", "3"]}], 
      RowBox[{"-", 
       FractionBox["58", "3"]}]},
     {
      RowBox[{"-", 
       FractionBox["65", "54"]}], 
      RowBox[{"-", 
       FractionBox["109", "9"]}], 
      RowBox[{"-", 
       FractionBox["142", "9"]}], 
      FractionBox["20", "3"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.971196954218645*^9, {3.9712648895742683`*^9, 3.971264894565123*^9}},
 CellLabel->
  "Out[4]//MatrixForm=",ExpressionUUID->"03de7409-04d3-48e2-a1a3-\
c36f64f382c1"]
}, Open  ]],

Cell["\<\
7. X+B^T-2(X^T-C)^T=D^-1+A^-1
\[DoubleRightArrow]X=B^T+2C^T-D^-1-A^-1\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, {3.9712674273985*^9, 
   3.971267456798381*^9}, {3.971267647198699*^9, 
   3.971267694311122*^9}},ExpressionUUID->"ebfb95ff-02b1-4d1a-bd24-\
595c751c65bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Transpose", "[", "B", "]"}], "+", 
   RowBox[{"2", 
    RowBox[{"Transpose", "[", "c", "]"}]}], "-", 
   RowBox[{"Inverse", "[", "d", "]"}], "-", 
   RowBox[{"Inverse", "[", "A", "]"}]}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971267698949272*^9, 3.971267739717931*^9}},
 CellLabel->"In[8]:=",ExpressionUUID->"cbc69fa2-0209-4ade-98c6-c702564f795c"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["9", "4"], 
      RowBox[{"-", 
       FractionBox["151", "40"]}], 
      RowBox[{"-", 
       FractionBox["89", "30"]}], 
      RowBox[{"-", 
       FractionBox["383", "60"]}]},
     {
      RowBox[{"-", 
       FractionBox["877", "456"]}], 
      RowBox[{"-", 
       FractionBox["2379", "1520"]}], 
      FractionBox["3419", "1140"], 
      RowBox[{"-", 
       FractionBox["4507", "2280"]}]},
     {
      FractionBox["545", "152"], 
      RowBox[{"-", 
       FractionBox["5059", "1520"]}], 
      RowBox[{"-", 
       FractionBox["1997", "380"]}], 
      FractionBox["1531", "760"]},
     {
      FractionBox["1", "456"], 
      RowBox[{"-", 
       FractionBox["9201", "1520"]}], 
      FractionBox["397", "380"], 
      FractionBox["2329", "760"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971267740438305*^9},
 CellLabel->
  "Out[8]//MatrixForm=",ExpressionUUID->"b14fd842-bf55-44ae-9968-\
2b97cbfc606a"]
}, Open  ]],

Cell["\<\
8. (AX^TB^T)^T+[(A^-1)^TX^-1B^-1]^-1=2I+(CD)^-1
\[DoubleRightArrow]X=B^-1 1/2[2I+(CD)^-1](A^T)^-1\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971265648864633*^9, {3.971266604967843*^9, 
   3.97126667953925*^9}, {3.9712670893131933`*^9, 3.97126714589534*^9}, 
   3.971267650917818*^9},ExpressionUUID->"856e8758-9fc8-4664-ba90-\
afdf43376241"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"1", "/", "2"}], 
   RowBox[{
    RowBox[{"Inverse", "[", "B", "]"}], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{"IdentityMatrix", "[", "4", "]"}]}], "+", 
      RowBox[{"Inverse", "[", 
       RowBox[{"c", ".", "d"}], "]"}]}], ")"}], ".", 
    RowBox[{"Inverse", "[", 
     RowBox[{"Transpose", "[", "A", "]"}], "]"}]}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971196860831357*^9, 3.971196889721924*^9}, {
   3.971196942676775*^9, 3.971196953278734*^9}, {3.971264711961635*^9, 
   3.971264736114634*^9}, {3.971264847209186*^9, 3.971264871186878*^9}, {
   3.971265427021261*^9, 3.971265501901807*^9}, 3.97126556417328*^9, {
   3.971267187315546*^9, 3.971267289078596*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"0457e4ec-17da-427e-ac5c-6f64535449c8"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["577", "196800"], 
      RowBox[{"-", 
       FractionBox["710821", "7478400"]}], 
      RowBox[{"-", 
       FractionBox["99167", "623200"]}], 
      FractionBox["345073", "2492800"]},
     {
      FractionBox["26447", "275520"], 
      RowBox[{"-", 
       FractionBox["942251", "10469760"]}], 
      RowBox[{"-", 
       FractionBox["26151", "124640"]}], 
      FractionBox["746143", "3489920"]},
     {
      RowBox[{"-", 
       FractionBox["41259", "262400"]}], 
      FractionBox["1793207", "9971200"], 
      FractionBox["229567", "2492800"], 
      RowBox[{"-", 
       FractionBox["2377073", "9971200"]}]},
     {
      RowBox[{"-", 
       FractionBox["1862401", "5510400"]}], 
      FractionBox["73201573", "209395200"], 
      FractionBox["201353", "2492800"], 
      FractionBox["8955151", "69798400"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.971196954218645*^9, {3.9712648895742683`*^9, 3.971264894565123*^9}, 
   3.971265532607895*^9, 3.971265566883185*^9, 3.971267313433395*^9},
 CellLabel->
  "Out[7]//MatrixForm=",ExpressionUUID->"1c0e6c62-4ade-4713-b957-\
3bb76c833d9d"]
}, Open  ]],

Cell["\<\
9. (X^-1+B)^T-A^-1=2(X^-1D)^T
\[DoubleRightArrow]X={[(I-2D)^-1(A^-1-B^T)]^T}^-1\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 
   3.971267654217277*^9},ExpressionUUID->"7aaafa81-6b88-4654-a0cb-\
434cc9d8f263"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Inverse", "[", 
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{"Inverse", "[", 
      RowBox[{
       RowBox[{"IdentityMatrix", "[", "4", "]"}], "-", 
       RowBox[{"2", "d"}]}], "]"}], ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Inverse", "[", "A", "]"}], "-", 
       RowBox[{"Transpose", "[", "B", "]"}]}], ")"}]}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971196860831357*^9, 3.971196889721924*^9}, {
   3.971196942676775*^9, 3.971196953278734*^9}, {3.971264711961635*^9, 
   3.971264736114634*^9}, {3.971264847209186*^9, 3.971264871186878*^9}, {
   3.971265427021261*^9, 3.971265501901807*^9}, 3.97126556417328*^9},
 CellLabel->"In[6]:=",ExpressionUUID->"de3ea8af-46e9-4128-a21b-359974e81ecb"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["3259", "16509"]}], 
      FractionBox["39703", "16509"], 
      FractionBox["520", "16509"], 
      FractionBox["7711", "16509"]},
     {
      FractionBox["3116", "5503"], 
      FractionBox["8292", "5503"], 
      RowBox[{"-", 
       FractionBox["4006", "5503"]}], 
      RowBox[{"-", 
       FractionBox["7528", "5503"]}]},
     {
      RowBox[{"-", 
       FractionBox["9560", "5503"]}], 
      RowBox[{"-", 
       FractionBox["6713", "5503"]}], 
      RowBox[{"-", 
       FractionBox["2078", "5503"]}], 
      FractionBox["4807", "5503"]},
     {
      FractionBox["2153", "16509"], 
      FractionBox["10408", "5503"], 
      FractionBox["11809", "16509"], 
      FractionBox["3325", "16509"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.971196954218645*^9, {3.9712648895742683`*^9, 3.971264894565123*^9}, 
   3.971265532607895*^9, 3.971265566883185*^9},
 CellLabel->
  "Out[6]//MatrixForm=",ExpressionUUID->"8e3225fb-7024-4634-87a2-\
a7b482623994"]
}, Open  ]],

Cell["\<\
10. [(CX^T)^-1+(DX^T)^-1]^T=(AB)^-1+DC
\[DoubleRightArrow]X=[(AB)^-1+DC]^-1[C^-1+D^-1]^T\
\>", "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 
   3.971268391286427*^9}},ExpressionUUID->"7873a8cc-88e0-4da2-9d8c-\
857aa4862c18"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Inverse", "[", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Inverse", "[", 
       RowBox[{"A", ".", "B"}], "]"}], "+", 
      RowBox[{"d", ".", "c"}]}], ")"}], "]"}], ".", 
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{"Inverse", "[", "c", "]"}], "+", 
     RowBox[{"Inverse", "[", "d", "]"}]}], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971268408825426*^9, 3.9712684535686817`*^9}},
 CellLabel->"In[9]:=",ExpressionUUID->"2997752f-28e5-4b35-8332-697435c64ea2"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["639752687", "1212176480"], 
      RowBox[{"-", 
       FractionBox["17359123611", "31516588480"]}], 
      RowBox[{"-", 
       FractionBox["3091350763", "31516588480"]}], 
      RowBox[{"-", 
       FractionBox["28184805953", "31516588480"]}]},
     {
      FractionBox["396953313", "1212176480"], 
      RowBox[{"-", 
       FractionBox["6592538229", "31516588480"]}], 
      RowBox[{"-", 
       FractionBox["358472997", "31516588480"]}], 
      RowBox[{"-", 
       FractionBox["14359263727", "31516588480"]}]},
     {
      FractionBox["415799373", "969741184"], 
      RowBox[{"-", 
       FractionBox["10115488977", "25213270784"]}], 
      RowBox[{"-", 
       FractionBox["1256458113", "25213270784"]}], 
      RowBox[{"-", 
       FractionBox["14288644835", "25213270784"]}]},
     {
      RowBox[{"-", 
       FractionBox["1511962599", "4848705920"]}], 
      FractionBox["14724854643", "126066353920"], 
      FractionBox["1780091523", "126066353920"], 
      FractionBox["62199515177", "126066353920"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.97126845441859*^9},
 CellLabel->
  "Out[9]//MatrixForm=",ExpressionUUID->"81f998f6-b8ae-4384-87ab-\
e7a516346fcb"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Demostraci\[OAcute]n idempotente, involutiva, nilpotente y \
peri\[OAcute]dica", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.9603734547625504`*^9}, {
  3.960373585255254*^9, 3.960373585629177*^9}, {3.960373640631687*^9, 
  3.9603736515713863`*^9}, {3.971268834351304*^9, 3.971268834801166*^9}, {
  3.971285800467811*^9, 
  3.971285802400531*^9}},ExpressionUUID->"e902e0fc-987f-437c-89ef-\
0f1dc2931003"],

Cell["\<\
11. Si A es una matriz idempotente demuestre que det(A)=0, o bien, det(A)=1.

Partimos de: A^2 = A. Aplicamos el determinante en ambos lados: det(A^2) = \
det(A). Por una propiedad del determinante, (det A)^2 = det A. Esto se \
reescribe como (det A)^2 - det A = 0 y factorizando: det A (det A - 1) = 0. \
Por tanto, det A = 0 o bien, det A = 1.\
\>", "Text",
 CellChangeTimes->{{3.9712860600493393`*^9, 
  3.971286069910554*^9}},ExpressionUUID->"471bb8d7-72ba-4854-aff8-\
e11af3221b56"],

Cell["\<\
12. Si una matriz A es involutiva entonces det(A) = 1 o det(A) = -1.\
\>", "Text",
 CellChangeTimes->{{3.971286088162257*^9, 
  3.971286088970664*^9}},ExpressionUUID->"d5e1c1e8-066f-46c1-9966-\
9dfa5650666c"],

Cell["\<\
Por definici\[OAcute]n de matriz involutiva: A^2 = I_n. Tomando \
determinantes: det(A^2) = det(I_n). Entonces (det A)^2 = 1 y det(A) = \
\[PlusMinus]1.\
\>", "Text",
 CellChangeTimes->{{3.971286092870494*^9, 
  3.971286105999319*^9}},ExpressionUUID->"4ca8824a-3e49-4966-896f-\
5c63dbf27a32"],

Cell["\<\
13. Si las matrices A y B son idempotentes y AB=BA, pruebe que AB es una \
matriz idempotente.

Sean A y B dos matrices idempotentes tales que AB = BA. Entonces A^2 = A y \
B^2 = B. Demostremos que C = AB es idempotente: C^2 = (AB)^2 = ABAB = A(BA)B \
= A(AB)B = A^2B^2 = AB = C.\
\>", "Text",
 CellChangeTimes->{{3.971286111907384*^9, 
  3.971286121989727*^9}},ExpressionUUID->"687d10de-c20b-42c1-b77b-\
de42a37a164f"],

Cell["\<\
14. Si una matriz A es nilpotente de orden n entonces I_n - A es invertible.

Sea A nilpotente de \[IAcute]\[DiscretionaryHyphen]ndice k, es decir, A^k = \
0_n. Consideremos I_n - A. Para demostrar que es invertible, encontramos su \
inversa: (I_n - A)(I_n + A + A^2 + ... + A^{k-1}) = I_n - A^k = I_n. Por \
tanto, (I_n - A)^(-1) = I_n + A + A^2 + ... + A^{k-1}.\
\>", "Text",
 CellChangeTimes->{{3.9712861404210453`*^9, 
  3.97128615404173*^9}},ExpressionUUID->"efe33d39-1b9a-43ea-89c7-\
098abcaf28a3"],

Cell["\<\
15. Si una matriz A es peri\[OAcute]dica de periodo k, demuestre que el \
promedio de sus potencias (sin considerar la potencia nula) hasta A^{k-1} es \
idempotente.

Sea P = 1/(k-1)(A + A^2 + ... + A^{k-1}). Calculemos AP: AP = 1/(k-1)(A^2 + \
A^3 + ... + A^k) = 1/(k-1)(A + A^2 + ... + A^{k-1}) = P (ya que A^k = A). \
Entonces AP = P. Ahora calculemos P^2: P^2 = 1/(k-1)(A + A^2 + ... + \
A^{k-1})P = 1/(k-1)(AP + A^2P + ... + A^{k-1}P). Como A^mP = P para todo m, \
se tiene P^2 = 1/(k-1)(P + ... + P) = P. Por tanto, P es idempotente.\
\>", "Text",
 CellChangeTimes->{{3.9712862068573093`*^9, 3.971286217261346*^9}, {
  3.9712862586734457`*^9, 
  3.9712862592275267`*^9}},ExpressionUUID->"3c8bb97c-4aee-42a2-abb9-\
e5cb1e5f98b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Reducir por filas y rango", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.960373473997078*^9}, {
  3.960373588001313*^9, 3.960373588479484*^9}, {3.960373654724263*^9, 
  3.960373662907571*^9}, {3.971268837281518*^9, 
  3.9712688381381474`*^9}},ExpressionUUID->"20840740-7c18-4b82-a513-\
6a8f498ea7eb"],

Cell[TextData[{
 "16. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", 
        FractionBox["20", "3"]}], "0", 
       RowBox[{"-", "11"}], "5", 
       RowBox[{"-", "4"}]},
      {
       RowBox[{"-", "2"}], "0", 
       RowBox[{"-", "3"}], "3", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]},
      {
       FractionBox["17", "3"], "0", "8", 
       RowBox[{"-", "11"}], "1"},
      {
       FractionBox["1", "3"], "0", "1", "2", "1"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.971341502196246*^9, 3.971341544773775*^9}, 
    3.971341619076233*^9},ExpressionUUID->
  "2a5ac708-55a9-499a-8b38-9c2b6b541b42"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}},ExpressionUUID->"5da980da-9dff-4544-9f96-\
aaa3fee189d7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["20", "3"]}], "0", 
        RowBox[{"-", "11"}], "5", 
        RowBox[{"-", "4"}]},
       {
        RowBox[{"-", "2"}], "0", 
        RowBox[{"-", "3"}], "3", 
        RowBox[{"-", 
         FractionBox["2", "3"]}]},
       {
        FractionBox["17", "3"], "0", "8", 
        RowBox[{"-", "11"}], "1"},
       {
        FractionBox["1", "3"], "0", "1", "2", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], ",", 
   RowBox[{"MatrixRank", "[", "A", "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.971341194517016*^9, 3.971341204780529*^9}, {
   3.971341302220232*^9, 3.971341349007224*^9}, 3.971341630954031*^9},
 CellLabel->"In[43]:=",ExpressionUUID->"732eaa44-4a83-4722-aa51-523d9445354e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", 
        RowBox[{"-", "9"}], 
        RowBox[{"-", 
         FractionBox["7", "3"]}]},
       {"0", "0", "1", "5", 
        FractionBox["16", "9"]},
       {"0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", "2"}], "}"}]], "Output",
 CellChangeTimes->{
  3.971341298594873*^9, {3.9713413309971323`*^9, 3.971341349362934*^9}, 
   3.9713416331104937`*^9},
 CellLabel->"Out[44]=",ExpressionUUID->"cc53bca3-8925-4fae-9780-fae92e7ac7c7"]
}, Open  ]],

Cell[TextData[{
 "17. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", 
        FractionBox["17", "6"]}], 
       RowBox[{"-", "11"}], 
       RowBox[{"-", "4"}], 
       RowBox[{"-", "1"}], 
       RowBox[{"-", "8"}], "4"},
      {
       RowBox[{"-", 
        FractionBox["2", "3"]}], 
       RowBox[{"-", "1"}], "3", 
       FractionBox["1", "2"], 
       RowBox[{"-", "1"}], "1"},
      {
       FractionBox["3", "2"], "1", "2", "0", "0", 
       RowBox[{"-", "2"}]},
      {
       RowBox[{"-", 
        FractionBox["3", "2"]}], "3", "2", "1", "3", "2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.971341502196246*^9, 3.971341544773775*^9}, 
    3.971341619076233*^9, 3.971341649356173*^9},ExpressionUUID->
  "d427c36a-caba-45bc-a3cd-dd67ae7f3882"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.971341249863291*^9}, 3.9713416561462708`*^9, {3.971341732971579*^9, 
   3.971341741925572*^9}},ExpressionUUID->"49c93598-0f0d-418d-acf3-\
9e7bb0c45398"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", 
         FractionBox["17", "6"]}], 
        RowBox[{"-", "11"}], 
        RowBox[{"-", "4"}], 
        RowBox[{"-", "1"}], 
        RowBox[{"-", "8"}], "4"},
       {
        RowBox[{"-", 
         FractionBox["2", "3"]}], 
        RowBox[{"-", "1"}], "3", 
        FractionBox["1", "2"], 
        RowBox[{"-", "1"}], "1"},
       {
        FractionBox["3", "2"], "1", "2", "0", "0", 
        RowBox[{"-", "2"}]},
       {
        RowBox[{"-", 
         FractionBox["3", "2"]}], "3", "2", "1", "3", "2"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], ",", 
   RowBox[{"MatrixRank", "[", "A", "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.971341363181274*^9, 3.971341370021791*^9}, 
   3.971341659568591*^9},
 CellLabel->"In[46]:=",ExpressionUUID->"b9063697-a6d5-4b41-8d4c-397bdddbd98b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", 
        RowBox[{"-", 
         FractionBox["21", "80"]}], 
        RowBox[{"-", 
         FractionBox["33", "80"]}], 
        RowBox[{"-", 
         FractionBox["27", "20"]}]},
       {"0", "1", "0", 
        FractionBox["17", "160"], 
        FractionBox["141", "160"], 
        RowBox[{"-", 
         FractionBox["1", "40"]}]},
       {"0", "0", "1", 
        FractionBox["23", "160"], 
        RowBox[{"-", 
         FractionBox["21", "160"]}], 
        FractionBox["1", "40"]},
       {"0", "0", "0", "0", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{3.9713413706886177`*^9, 3.971341660624673*^9},
 CellLabel->"Out[47]=",ExpressionUUID->"eb6458a4-6aa5-465a-8763-22e0f8ecf41e"]
}, Open  ]],

Cell[TextData[{
 "18. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "3"}], 
       RowBox[{"-", "11"}], "5", 
       RowBox[{"-", 
        FractionBox["19", "3"]}], "7", 
       RowBox[{"-", 
        FractionBox["41", "3"]}]},
      {
       RowBox[{"-", "2"}], 
       RowBox[{"-", "3"}], 
       RowBox[{"-", "1"}], 
       RowBox[{"-", "1"}], "0", 
       RowBox[{"-", "2"}]},
      {"1", 
       RowBox[{"-", "1"}], "0", 
       RowBox[{"-", 
        FractionBox["2", "3"]}], "1", 
       RowBox[{"-", "3"}]},
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", 
        FractionBox["2", "3"]}], 
       RowBox[{"-", 
        FractionBox["2", "3"]}], "0", 
       RowBox[{"-", "1"}], "1"},
      {"1", "1", 
       RowBox[{"-", "3"}], "1", 
       RowBox[{"-", "1"}], 
       RowBox[{"-", 
        FractionBox["2", "3"]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.971341502196246*^9, 3.971341544773775*^9}, 
    3.971341619076233*^9, {3.971341649356173*^9, 3.971341674846224*^9}},
  ExpressionUUID->"70b344a6-6b1a-46f2-933a-85e95cd5886f"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.971341258567754*^9}, 3.971341681312358*^9, {3.97134172050395*^9, 
   3.971341727002022*^9}, {3.971341771671597*^9, 
   3.971341774941782*^9}},ExpressionUUID->"1fcf9aed-24c2-4c48-a928-\
5d0c7501803e"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "3"}], 
        RowBox[{"-", "11"}], "5", 
        RowBox[{"-", 
         FractionBox["19", "3"]}], "7", 
        RowBox[{"-", 
         FractionBox["41", "3"]}]},
       {
        RowBox[{"-", "2"}], 
        RowBox[{"-", "3"}], 
        RowBox[{"-", "1"}], 
        RowBox[{"-", "1"}], "0", 
        RowBox[{"-", "2"}]},
       {"1", 
        RowBox[{"-", "1"}], "0", 
        RowBox[{"-", 
         FractionBox["2", "3"]}], "1", 
        RowBox[{"-", "3"}]},
       {
        RowBox[{"-", "1"}], 
        RowBox[{"-", 
         FractionBox["2", "3"]}], 
        RowBox[{"-", 
         FractionBox["2", "3"]}], "0", 
        RowBox[{"-", "1"}], "1"},
       {"1", "1", 
        RowBox[{"-", "3"}], "1", 
        RowBox[{"-", "1"}], 
        RowBox[{"-", 
         FractionBox["2", "3"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], ",", 
   RowBox[{"MatrixRank", "[", "A", "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.9713413949226513`*^9, 3.9713414049003067`*^9}, 
   3.971341683862043*^9},
 CellLabel->"In[50]:=",ExpressionUUID->"29e8135a-6d19-43de-a566-2ffdb9c68234"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", 
        RowBox[{"-", 
         FractionBox["5", "3"]}], 
        FractionBox["14", "9"]},
       {"0", "1", "0", "0", 
        FractionBox["20", "3"], 
        RowBox[{"-", 
         FractionBox["74", "9"]}]},
       {"0", "0", "1", "0", 
        RowBox[{"-", 
         FractionBox["8", "3"]}], 
        FractionBox["79", "18"]},
       {"0", "0", "0", "1", 
        RowBox[{"-", "14"}], 
        FractionBox["115", "6"]},
       {"0", "0", "0", "0", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", "4"}], "}"}]], "Output",
 CellChangeTimes->{3.971341429729072*^9, 3.9713416842369337`*^9},
 CellLabel->"Out[51]=",ExpressionUUID->"d42f917b-7f87-46a0-8ba2-9b626efce9a1"]
}, Open  ]],

Cell[TextData[{
 "19. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"6", 
       RowBox[{"-", 
        FractionBox["3", "2"]}], "2", 
       RowBox[{"-", "3"}], 
       RowBox[{"-", "4"}], 
       RowBox[{"-", "9"}]},
      {
       RowBox[{"-", "2"}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       RowBox[{"-", "2"}], 
       FractionBox["1", "3"], 
       RowBox[{"-", "1"}], 
       RowBox[{"-", "2"}]},
      {"3", 
       RowBox[{"-", "3"}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}], "1", 
       RowBox[{"-", "2"}], 
       RowBox[{"-", 
        FractionBox["3", "2"]}]},
      {
       RowBox[{"-", "5"}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       RowBox[{"-", 
        FractionBox["7", "2"]}], 
       FractionBox["8", "3"], "1", 
       FractionBox["7", "2"]},
      {"2", "2", "3", 
       RowBox[{"-", "2"}], "1", "0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.971341502196246*^9, 3.971341544773775*^9}, 
    3.971341619076233*^9, {3.971341649356173*^9, 3.971341696221881*^9}},
  ExpressionUUID->"6c62d649-1d54-425c-b9e2-9047f539012e"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412676392937`*^9}, {3.9713417045096073`*^9, 
   3.9713417162896748`*^9}, {3.9713417782125273`*^9, 
   3.971341780910067*^9}},ExpressionUUID->"4e5978ed-c1d9-41cc-8a0f-\
617c2526453c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"6", 
        RowBox[{"-", 
         FractionBox["3", "2"]}], "2", 
        RowBox[{"-", "3"}], 
        RowBox[{"-", "4"}], 
        RowBox[{"-", "9"}]},
       {
        RowBox[{"-", "2"}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        RowBox[{"-", "2"}], 
        FractionBox["1", "3"], 
        RowBox[{"-", "1"}], 
        RowBox[{"-", "2"}]},
       {"3", 
        RowBox[{"-", "3"}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}], "1", 
        RowBox[{"-", "2"}], 
        RowBox[{"-", 
         FractionBox["3", "2"]}]},
       {
        RowBox[{"-", "5"}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        RowBox[{"-", 
         FractionBox["7", "2"]}], 
        FractionBox["8", "3"], "1", 
        FractionBox["7", "2"]},
       {"2", "2", "3", 
        RowBox[{"-", "2"}], "1", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], ",", 
   RowBox[{"MatrixRank", "[", "A", "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.9713413864180813`*^9, 3.971341409997464*^9}, 
   3.971341707789135*^9},
 CellLabel->"In[53]:=",ExpressionUUID->"2d56d49c-5a6f-48b3-beed-672f5b003c18"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", 
        RowBox[{"-", 
         FractionBox["19", "9"]}], 
        RowBox[{"-", 
         FractionBox["29", "12"]}], 
        RowBox[{"-", 
         FractionBox["79", "12"]}]},
       {"0", "1", "0", 
        RowBox[{"-", 
         FractionBox["26", "9"]}], 
        RowBox[{"-", 
         FractionBox["7", "3"]}], 
        RowBox[{"-", 
         FractionBox["23", "3"]}]},
       {"0", "0", "1", 
        FractionBox["8", "3"], 
        FractionBox["7", "2"], 
        FractionBox["19", "2"]},
       {"0", "0", "0", "0", "0", "0"},
       {"0", "0", "0", "0", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{3.971341437294709*^9, 3.971341708870316*^9},
 CellLabel->"Out[54]=",ExpressionUUID->"06fb4371-e105-4470-8da1-d9f6b4b32e0a"]
}, Open  ]],

Cell[TextData[{
 "20. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", 
        FractionBox["3", "2"]}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       FractionBox["1", "3"], 
       FractionBox["1", "2"], 
       RowBox[{"-", "2"}]},
      {"7", "8", 
       RowBox[{"-", 
        FractionBox["1", "6"]}], 
       RowBox[{"-", 
        FractionBox["28", "3"]}], 
       RowBox[{"-", 
        FractionBox["11", "6"]}], 
       RowBox[{"-", "7"}]},
      {"1", "1", 
       RowBox[{"-", 
        FractionBox["1", "3"]}], 
       RowBox[{"-", "1"}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       RowBox[{"-", "3"}]},
      {
       RowBox[{"-", "1"}], 
       FractionBox["1", "2"], "3", "0", 
       RowBox[{"-", 
        FractionBox["2", "3"]}], 
       RowBox[{"-", "1"}]},
      {
       FractionBox["3", "2"], "2", "2", 
       RowBox[{"-", "2"}], "1", 
       RowBox[{"-", "1"}]},
      {"0", 
       RowBox[{"-", "1"}], "1", "3", "3", "2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.971341502196246*^9, 3.971341544773775*^9}, 
    3.971341619076233*^9, {3.971341649356173*^9, 3.971341696221881*^9}, 
    3.971341804276276*^9},ExpressionUUID->
  "201b3291-634e-448d-b785-071686ecc2a1"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.971341242517027*^9}, 3.9713412806425056`*^9, {3.9713417854157057`*^9, 
   3.9713418156558533`*^9}},ExpressionUUID->"8afcff4f-0e42-422d-aac2-\
65b3b6bda310"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1"}], 
        RowBox[{"-", 
         FractionBox["3", "2"]}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        FractionBox["1", "3"], 
        FractionBox["1", "2"], 
        RowBox[{"-", "2"}]},
       {"7", "8", 
        RowBox[{"-", 
         FractionBox["1", "6"]}], 
        RowBox[{"-", 
         FractionBox["28", "3"]}], 
        RowBox[{"-", 
         FractionBox["11", "6"]}], 
        RowBox[{"-", "7"}]},
       {"1", "1", 
        RowBox[{"-", 
         FractionBox["1", "3"]}], 
        RowBox[{"-", "1"}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        RowBox[{"-", "3"}]},
       {
        RowBox[{"-", "1"}], 
        FractionBox["1", "2"], "3", "0", 
        RowBox[{"-", 
         FractionBox["2", "3"]}], 
        RowBox[{"-", "1"}]},
       {
        FractionBox["3", "2"], "2", "2", 
        RowBox[{"-", "2"}], "1", 
        RowBox[{"-", "1"}]},
       {"0", 
        RowBox[{"-", "1"}], "1", "3", "3", "2"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"RowReduce", "[", "A", "]"}], "//", "MatrixForm"}], ",", 
   RowBox[{"MatrixRank", "[", "A", "]"}]}], "}"}]}], "Input",
 CellChangeTimes->{{3.971341391467659*^9, 3.971341415469427*^9}, 
   3.971341818634598*^9},
 CellLabel->"In[56]:=",ExpressionUUID->"110e99f3-3956-4855-a86f-c407bd3e0422"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "0", "0", "0", "0", 
        RowBox[{"-", 
         FractionBox["21250", "929"]}]},
       {"0", "1", "0", "0", "0", 
        FractionBox["21842", "929"]},
       {"0", "0", "1", "0", "0", 
        RowBox[{"-", 
         FractionBox["9024", "929"]}]},
       {"0", "0", "0", "1", "0", 
        FractionBox["1866", "929"]},
       {"0", "0", "0", "0", "1", 
        FractionBox["9042", "929"]},
       {"0", "0", "0", "0", "0", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", "5"}], "}"}]], "Output",
 CellChangeTimes->{3.971341441893433*^9, 3.971341819724588*^9},
 CellLabel->"Out[57]=",ExpressionUUID->"4895b902-2c9d-4156-a690-938a18cdfe86"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de la inversa por Gauss y la matriz adjunta", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.960373500441454*^9}, {
  3.960373591767436*^9, 3.9603735921993237`*^9}, {3.960373675326418*^9, 
  3.960373682565652*^9}, {3.971340856655781*^9, 
  3.971340857042953*^9}},ExpressionUUID->"5ce77ced-8f4b-4e2e-8bc3-\
a5e83e35c495"],

Cell[TextData[{
 "21. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", 
       RowBox[{"-", "1"}], "1", "2"},
      {
       RowBox[{"-", "3"}], "2", "4", 
       RowBox[{"-", "2"}]},
      {"3", "3", 
       RowBox[{"-", "5"}], 
       RowBox[{"-", "1"}]},
      {
       RowBox[{"-", "5"}], 
       RowBox[{"-", "3"}], 
       RowBox[{"-", "2"}], "2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{3.971343767800458*^9},ExpressionUUID->
  "15fccb91-bded-45af-a8d6-8fecb8cf0647"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.9713440099662123`*^9}, 
   3.9713440457672987`*^9},ExpressionUUID->"3fb84f8a-11b0-43ce-898e-\
659b85b560fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Inverse", "[", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", 
        RowBox[{"-", "1"}], "1", "2"},
       {
        RowBox[{"-", "3"}], "2", "4", 
        RowBox[{"-", "2"}]},
       {"3", "3", 
        RowBox[{"-", "5"}], 
        RowBox[{"-", "1"}]},
       {
        RowBox[{"-", "5"}], 
        RowBox[{"-", "3"}], 
        RowBox[{"-", "2"}], "2"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.9713441149420147`*^9, 3.971344155106072*^9}, 
   3.9713459314233294`*^9},
 CellLabel->"In[61]:=",ExpressionUUID->"0e6b07c0-291e-4ac1-80f2-8509692dabf7"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["6", "227"]}], 
      RowBox[{"-", 
       FractionBox["33", "227"]}], 
      RowBox[{"-", 
       FractionBox["14", "227"]}], 
      RowBox[{"-", 
       FractionBox["34", "227"]}]},
     {
      FractionBox["94", "227"], 
      FractionBox["63", "227"], 
      FractionBox["68", "227"], 
      FractionBox["3", "227"]},
     {
      FractionBox["23", "227"], 
      FractionBox["13", "227"], 
      RowBox[{"-", 
       FractionBox["22", "227"]}], 
      RowBox[{"-", 
       FractionBox["21", "227"]}]},
     {
      FractionBox["149", "227"], 
      FractionBox["25", "227"], 
      FractionBox["45", "227"], 
      FractionBox["12", "227"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.9713459286012783`*^9, 3.9713459382015553`*^9}},
 CellLabel->
  "Out[61]//MatrixForm=",ExpressionUUID->"cccaaf1f-da61-46c3-9d90-\
65a95b90b2bf"]
}, Open  ]],

Cell[TextData[{
 "22. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"3", "4", "5", 
       RowBox[{"-", "3"}]},
      {"5", 
       RowBox[{"-", "3"}], "1", 
       RowBox[{"-", "5"}]},
      {"0", "0", 
       RowBox[{"-", "4"}], "0"},
      {"1", 
       RowBox[{"-", "3"}], "3", "1"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{3.971343767800458*^9},ExpressionUUID->
  "0d1a5878-ad1e-4f34-849e-ad5fd4a6312f"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344020227549*^9}, {
   3.971344052657754*^9, 
   3.9713440919298687`*^9}},ExpressionUUID->"9be1c3cb-0714-4f27-b260-\
4c1a6c181dde"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Inverse", "[", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3", "4", "5", 
        RowBox[{"-", "3"}]},
       {"5", 
        RowBox[{"-", "3"}], "1", 
        RowBox[{"-", "5"}]},
       {"0", "0", 
        RowBox[{"-", "4"}], "0"},
       {"1", 
        RowBox[{"-", "3"}], "3", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.971344162113875*^9},
 CellLabel->"In[62]:=",ExpressionUUID->"ccb298da-8f20-4f75-b5b3-218dc76bd524"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["9", "29"], 
      RowBox[{"-", 
       FractionBox["5", "58"]}], 
      FractionBox["43", "58"], 
      FractionBox["1", "2"]},
     {
      FractionBox["5", "29"], 
      RowBox[{"-", 
       FractionBox["3", "29"]}], 
      FractionBox["11", "58"], "0"},
     {"0", "0", 
      RowBox[{"-", 
       FractionBox["1", "4"]}], "0"},
     {
      FractionBox["6", "29"], 
      RowBox[{"-", 
       FractionBox["13", "58"]}], 
      FractionBox["67", "116"], 
      FractionBox["1", "2"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971346655366431*^9},
 CellLabel->
  "Out[62]//MatrixForm=",ExpressionUUID->"4e95de18-1c57-4bcb-9f1a-\
d44577cd56bb"]
}, Open  ]],

Cell[TextData[{
 "23. ",
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "5", 
      RowBox[{"-", "3"}], 
      FractionBox["5", "3"]},
     {"4", "1", "3", 
      RowBox[{"-", "2"}]},
     {"5", "5", "1", "1"},
     {"0", "2", 
      RowBox[{"-", "4"}], 
      FractionBox["4", "5"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}]],
  CellChangeTimes->{3.971343767800458*^9},ExpressionUUID->
  "2d9aa566-3c70-4a05-ad3b-9a5ed7e2fcf3"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.9713440257897453`*^9}, {
   3.971344065119649*^9, 
   3.971344098884843*^9}},ExpressionUUID->"7b921e29-b0f3-4adf-b9e0-\
6dd83174ddab"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Inverse", "[", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "5", 
       RowBox[{"-", "3"}], 
       FractionBox["5", "3"]},
      {"4", "1", "3", 
       RowBox[{"-", "2"}]},
      {"5", "5", "1", "1"},
      {"0", "2", 
       RowBox[{"-", "4"}], 
       FractionBox["4", "5"]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.971344168085437*^9},
 CellLabel->"In[63]:=",ExpressionUUID->"5d9b9177-1b62-47b3-a98b-a6048bb0fcaf"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["321", "935"]}], 
      RowBox[{"-", 
       FractionBox["10", "187"]}], 
      FractionBox["227", "935"], 
      FractionBox["52", "187"]},
     {
      FractionBox["354", "935"], 
      FractionBox["32", "187"], 
      RowBox[{"-", 
       FractionBox["128", "935"]}], 
      RowBox[{"-", 
       FractionBox["71", "374"]}]},
     {
      FractionBox["24", "187"], 
      RowBox[{"-", 
       FractionBox["5", "187"]}], 
      FractionBox["4", "187"], 
      RowBox[{"-", 
       FractionBox["135", "374"]}]},
     {
      RowBox[{"-", 
       FractionBox["57", "187"]}], 
      RowBox[{"-", 
       FractionBox["105", "187"]}], 
      FractionBox["84", "187"], 
      RowBox[{"-", 
       FractionBox["15", "187"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.97134668932017*^9},
 CellLabel->
  "Out[63]//MatrixForm=",ExpressionUUID->"735ff458-62f1-4ad9-9698-\
35f5c4587f45"]
}, Open  ]],

Cell[TextData[{
 "24. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "0", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       RowBox[{"-", 
        FractionBox["5", "3"]}]},
      {
       RowBox[{"-", "4"}], 
       RowBox[{"-", "3"}], "0", 
       RowBox[{"-", "1"}]},
      {
       RowBox[{"-", "1"}], "3", "2", 
       RowBox[{"-", "1"}]},
      {"1", 
       RowBox[{"-", "3"}], "1", 
       FractionBox["5", "3"]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{3.971343767800458*^9},ExpressionUUID->
  "8460a74f-632f-4b99-a40c-0177cf656c29"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.9713440284759274`*^9}, 
   3.971344071066773*^9},ExpressionUUID->"cdc10fd9-1e0d-4e04-b0a9-\
af68d85e8e72"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Inverse", "[", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0", "0", 
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        RowBox[{"-", 
         FractionBox["5", "3"]}]},
       {
        RowBox[{"-", "4"}], 
        RowBox[{"-", "3"}], "0", 
        RowBox[{"-", "1"}]},
       {
        RowBox[{"-", "1"}], "3", "2", 
        RowBox[{"-", "1"}]},
       {"1", 
        RowBox[{"-", "3"}], "1", 
        FractionBox["5", "3"]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.971344174614456*^9},
 CellLabel->"In[64]:=",ExpressionUUID->"ccb658af-ebef-4eb2-a73b-e584529653c4"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["11", "35"], 
      RowBox[{"-", 
       FractionBox["1", "5"]}], 
      RowBox[{"-", 
       FractionBox["1", "70"]}], 
      FractionBox["13", "70"]},
     {
      RowBox[{"-", 
       FractionBox["43", "210"]}], 
      RowBox[{"-", 
       FractionBox["1", "15"]}], 
      FractionBox["23", "420"], 
      RowBox[{"-", 
       FractionBox["89", "420"]}]},
     {
      FractionBox["1", "7"], "0", 
      FractionBox["5", "14"], 
      FractionBox["5", "14"]},
     {
      RowBox[{"-", 
       FractionBox["9", "14"]}], "0", 
      RowBox[{"-", 
       FractionBox["3", "28"]}], 
      RowBox[{"-", 
       FractionBox["3", "28"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971346716760879*^9},
 CellLabel->
  "Out[64]//MatrixForm=",ExpressionUUID->"201056eb-b5ef-4569-9d00-\
e31344424030"]
}, Open  ]],

Cell[TextData[{
 "25. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "4", 
       RowBox[{"-", "5"}], 
       FractionBox["4", "5"], 
       RowBox[{"-", 
        FractionBox["4", "3"]}]},
      {"5", "3", 
       FractionBox["2", "5"], 
       FractionBox["4", "5"], "2"},
      {
       FractionBox["3", "2"], 
       FractionBox["3", "4"], 
       RowBox[{"-", "2"}], "1", "5"},
      {
       RowBox[{"-", "3"}], 
       FractionBox["3", "2"], 
       RowBox[{"-", "2"}], 
       RowBox[{"-", "4"}], 
       RowBox[{"-", 
        FractionBox["3", "4"]}]},
      {
       RowBox[{"-", 
        FractionBox["1", "4"]}], 
       RowBox[{"-", "1"}], "2", 
       RowBox[{"-", "3"}], "1"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{3.9713437883486347`*^9},ExpressionUUID->
  "9e2e608c-3f16-4f86-8edf-dbd53a290193"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 
   3.971344038568184*^9}},ExpressionUUID->"10dddb71-6375-4f16-919d-\
c7872d3fc7d4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Inverse", "[", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "4", 
        RowBox[{"-", "5"}], 
        FractionBox["4", "5"], 
        RowBox[{"-", 
         FractionBox["4", "3"]}]},
       {"5", "3", 
        FractionBox["2", "5"], 
        FractionBox["4", "5"], "2"},
       {
        FractionBox["3", "2"], 
        FractionBox["3", "4"], 
        RowBox[{"-", "2"}], "1", "5"},
       {
        RowBox[{"-", "3"}], 
        FractionBox["3", "2"], 
        RowBox[{"-", "2"}], 
        RowBox[{"-", "4"}], 
        RowBox[{"-", 
         FractionBox["3", "4"]}]},
       {
        RowBox[{"-", 
         FractionBox["1", "4"]}], 
        RowBox[{"-", "1"}], "2", 
        RowBox[{"-", "3"}], "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.971344180270241*^9},
 CellLabel->"In[65]:=",ExpressionUUID->"42646ab5-5c26-43c1-898b-e7a8d25c1cfb"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["6198", "12197"], 
      RowBox[{"-", 
       FractionBox["1961", "12197"]}], 
      RowBox[{"-", 
       FractionBox["1788", "60985"]}], 
      RowBox[{"-", 
       FractionBox["31112", "60985"]}], 
      FractionBox["46536", "60985"]},
     {
      RowBox[{"-", 
       FractionBox["74106", "134167"]}], 
      FractionBox["62647", "134167"], 
      RowBox[{"-", 
       FractionBox["39784", "670835"]}], 
      FractionBox["428664", "670835"], 
      RowBox[{"-", 
       FractionBox["600092", "670835"]}]},
     {
      RowBox[{"-", 
       FractionBox["70575", "134167"]}], 
      FractionBox["44970", "134167"], 
      RowBox[{"-", 
       FractionBox["13096", "134167"]}], 
      FractionBox["51536", "134167"], 
      RowBox[{"-", 
       FractionBox["79908", "134167"]}]},
     {
      RowBox[{"-", 
       FractionBox["76035", "268334"]}], 
      FractionBox["59685", "536668"], 
      FractionBox["2099", "134167"], 
      FractionBox["19606", "134167"], 
      RowBox[{"-", 
       FractionBox["76323", "134167"]}]},
     {
      RowBox[{"-", 
       FractionBox["2724", "12197"]}], 
      FractionBox["1098", "12197"], 
      FractionBox["10704", "60985"], 
      FractionBox["11076", "60985"], 
      RowBox[{"-", 
       FractionBox["13368", "60985"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9713467297348423`*^9},
 CellLabel->
  "Out[65]//MatrixForm=",ExpressionUUID->"27fee49e-8152-453b-b57c-\
1c47f993afa4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo del determinante por cofactores", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.9603735354994173`*^9}, {
  3.960373597120243*^9, 3.960373597557006*^9}, {3.9603736753270693`*^9, 
  3.96037369444316*^9}, {3.971340863478855*^9, 3.971340863870948*^9}, {
  3.971347691249593*^9, 
  3.9713476938458138`*^9}},ExpressionUUID->"cc17a8a9-8f7e-4c16-9898-\
c9fd826208ba"],

Cell[TextData[{
 "26. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "3"}], 
       RowBox[{"-", "1"}], "1"},
      {"2", 
       RowBox[{"-", "3"}], 
       RowBox[{"-", "2"}]},
      {"1", 
       RowBox[{"-", "2"}], 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.9713473535824223`*^9, 3.971347374165609*^9}},
  ExpressionUUID->"17ae60e1-40d0-481f-ae60-6af15841c976"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347322058614*^9, 3.971347405384101*^9}, {3.971347710150364*^9, 
   3.971347710307417*^9}},ExpressionUUID->"40db02dd-d165-4dc7-913a-\
979bf33e3770"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "3"}], 
       RowBox[{"-", "1"}], "1"},
      {"2", 
       RowBox[{"-", "3"}], 
       RowBox[{"-", "2"}]},
      {"1", 
       RowBox[{"-", "2"}], 
       RowBox[{"-", "1"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellChangeTimes->{{3.9713473619912777`*^9, 3.971347367566482*^9}, 
   3.971347410874358*^9},
 CellLabel->"In[96]:=",ExpressionUUID->"a14575ef-681d-41f1-962e-8286748a6cd6"],

Cell[BoxData["2"], "Output",
 CellChangeTimes->{3.971347369149274*^9, 3.971347411726736*^9},
 CellLabel->"Out[96]=",ExpressionUUID->"cd37a008-88ac-4387-9ccf-ea597231271b"]
}, Open  ]],

Cell[TextData[{
 "27. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"0", "4", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]},
      {"0", "2", 
       RowBox[{"-", "3"}]},
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", 
        FractionBox["3", "4"]}], 
       FractionBox["1", "4"]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.9713473535824223`*^9, 3.971347374165609*^9}, 
    3.971347422631857*^9},ExpressionUUID->
  "462e5d78-d6c5-4bca-89b3-1c1ade406a0a"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347322058614*^9, 3.971347405384101*^9}, {3.97134744408628*^9, 
   3.971347454625743*^9}, {3.971347716105393*^9, 
   3.971347716389518*^9}},ExpressionUUID->"fe441283-d038-49b6-acb3-\
878121acd77e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "4", 
      RowBox[{"-", 
       FractionBox["2", "3"]}]},
     {"0", "2", 
      RowBox[{"-", "3"}]},
     {
      RowBox[{"-", "1"}], 
      RowBox[{"-", 
       FractionBox["3", "4"]}], 
      FractionBox["1", "4"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], "]"}]], "Input",
 CellChangeTimes->{{3.971347456217716*^9, 3.9713474622239017`*^9}},
 CellLabel->"In[99]:=",ExpressionUUID->"3107df38-d85e-4b88-975a-fb972e49b401"],

Cell[BoxData[
 FractionBox["32", "3"]], "Output",
 CellChangeTimes->{3.971347462611783*^9},
 CellLabel->"Out[99]=",ExpressionUUID->"9a6d16f1-0332-430c-989e-a475964f6da4"]
}, Open  ]],

Cell[TextData[{
 "28. ",
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["1", "2"]}], 
      RowBox[{"-", "4"}], 
      FractionBox["1", "3"]},
     {"1", 
      FractionBox["1", "4"], 
      RowBox[{"-", "2"}]},
     {
      RowBox[{"-", "4"}], 
      FractionBox["1", "4"], 
      RowBox[{"-", 
       FractionBox["3", "4"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}]],
  CellChangeTimes->{{3.971347390508605*^9, 3.9713473920867767`*^9}},
  ExpressionUUID->"0de4994d-b24b-47c2-9c21-2ff854734577"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347322058614*^9, 3.971347333397765*^9}, 3.971347418055091*^9, {
   3.971347472373893*^9, 3.971347472960114*^9}, {3.971347720104005*^9, 
   3.9713477202858458`*^9}},ExpressionUUID->"3db56c58-a488-4229-a51c-\
fb63d3989ef1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["1", "2"]}], 
      RowBox[{"-", "4"}], 
      FractionBox["1", "3"]},
     {"1", 
      FractionBox["1", "4"], 
      RowBox[{"-", "2"}]},
     {
      RowBox[{"-", "4"}], 
      FractionBox["1", "4"], 
      RowBox[{"-", 
       FractionBox["3", "4"]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}], "]"}]], "Input",
 CellChangeTimes->{{3.971347390508605*^9, 3.9713473920867767`*^9}},
 CellLabel->"In[95]:=",ExpressionUUID->"fe95656c-1f56-48d3-9278-a5158f3ce1c1"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["3335", "96"]}]], "Output",
 CellChangeTimes->{3.971347392940564*^9},
 CellLabel->"Out[95]=",ExpressionUUID->"cbb33c1b-318e-43a9-8f32-ecff5e4918a9"]
}, Open  ]],

Cell[TextData[{
 "29. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       RowBox[{"-", "4"}], "1", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]},
      {"3", "0", "1", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]},
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", "3"}], "4", 
       RowBox[{"-", "4"}]},
      {"0", 
       RowBox[{"-", "3"}], 
       FractionBox["3", "4"], 
       RowBox[{"-", 
        FractionBox["1", "4"]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.9713473535824223`*^9, 3.971347374165609*^9}, 
    3.971347422631857*^9, 3.971347479356514*^9},ExpressionUUID->
  "2be277a4-9c09-4030-921c-844c5a0517a9"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347322058614*^9, 3.9713473367136097`*^9}, {3.9713474891295433`*^9, 
   3.971347496852995*^9}, {3.9713477245804358`*^9, 
   3.971347724804492*^9}},ExpressionUUID->"9fd5f8da-e3ed-41d4-b1fc-\
a741b61ff560"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       RowBox[{"-", "4"}], "1", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]},
      {"3", "0", "1", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]},
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", "3"}], "4", 
       RowBox[{"-", "4"}]},
      {"0", 
       RowBox[{"-", "3"}], 
       FractionBox["3", "4"], 
       RowBox[{"-", 
        FractionBox["1", "4"]}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellChangeTimes->{{3.971347498788488*^9, 3.971347500577799*^9}},
 CellLabel->
  "In[102]:=",ExpressionUUID->"e0e0e209-d049-4e70-b57d-56749875905c"],

Cell[BoxData[
 FractionBox["121", "16"]], "Output",
 CellChangeTimes->{3.971347501476295*^9},
 CellLabel->
  "Out[102]=",ExpressionUUID->"13399c64-f8e6-4697-8144-d9ee3dbceecd"]
}, Open  ]],

Cell[TextData[{
 "30. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"3", "0", "0", 
       RowBox[{"-", "2"}], 
       RowBox[{"-", "2"}]},
      {"4", 
       FractionBox["2", "3"], 
       RowBox[{"-", "1"}], "0", "0"},
      {"1", 
       RowBox[{"-", "4"}], "4", "0", 
       RowBox[{"-", "4"}]},
      {
       FractionBox["2", "3"], "1", "2", "2", "0"},
      {
       FractionBox["3", "4"], "4", 
       RowBox[{"-", "3"}], "0", "2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.9713473535824223`*^9, 3.971347374165609*^9}, 
    3.971347422631857*^9, {3.971347479356514*^9, 3.971347512522438*^9}},
  ExpressionUUID->"5c22aa85-3f8d-4ee8-bde7-6a9b9afe6d9f"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347322058614*^9, 3.971347341206555*^9}, {3.97134749472544*^9, 
   3.971347521029748*^9}, 
   3.971347728418336*^9},ExpressionUUID->"738dea23-4b81-411d-b146-\
f3eb44bc69a6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"3", "0", "0", 
       RowBox[{"-", "2"}], 
       RowBox[{"-", "2"}]},
      {"4", 
       FractionBox["2", "3"], 
       RowBox[{"-", "1"}], "0", "0"},
      {"1", 
       RowBox[{"-", "4"}], "4", "0", 
       RowBox[{"-", "4"}]},
      {
       FractionBox["2", "3"], "1", "2", "2", "0"},
      {
       FractionBox["3", "4"], "4", 
       RowBox[{"-", "3"}], "0", "2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellChangeTimes->{{3.971347525555418*^9, 3.971347527085616*^9}},
 CellLabel->
  "In[107]:=",ExpressionUUID->"e1236856-96f6-449e-a766-41aab5dcba01"],

Cell[BoxData[
 FractionBox["898", "9"]], "Output",
 CellChangeTimes->{3.9713475282756023`*^9},
 CellLabel->
  "Out[107]=",ExpressionUUID->"0d86865d-f1d2-4e82-bad3-d5b4cbf06937"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo del determinante usando propiedades", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.960373518218595*^9}, {
  3.960373594690192*^9, 3.960373595079137*^9}, {3.9603736753267508`*^9, 
  3.9603736884116488`*^9}, {3.971340860583961*^9, 3.971340860958077*^9}, {
  3.9713476868303127`*^9, 
  3.971347700192284*^9}},ExpressionUUID->"adf13ff3-b331-433f-8659-\
5f26f1afb197"],

Cell[TextData[{
 "31. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "2"}], "3", 
       RowBox[{"-", 
        FractionBox["5", "3"]}]},
      {
       RowBox[{"-", "2"}], 
       FractionBox["1", "5"], 
       FractionBox["4", "5"]},
      {
       RowBox[{"-", 
        FractionBox["1", "5"]}], 
       RowBox[{"-", "3"}], "0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.97134710114743*^9, 3.97134711902172*^9}},
  ExpressionUUID->"8456c55c-bbdd-41ad-88e0-f6659e8e4177"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.9713471606667213`*^9}, {3.971347732933402*^9, 
   3.971347733244419*^9}},ExpressionUUID->"14451dd8-a6ff-4ce6-b13f-\
d2d1a5227257"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "2"}], "3", 
       RowBox[{"-", 
        FractionBox["5", "3"]}]},
      {
       RowBox[{"-", "2"}], 
       FractionBox["1", "5"], 
       FractionBox["4", "5"]},
      {
       RowBox[{"-", 
        FractionBox["1", "5"]}], 
       RowBox[{"-", "3"}], "0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellChangeTimes->{{3.971347218918721*^9, 3.971347224945528*^9}},
 CellLabel->"In[85]:=",ExpressionUUID->"2cfa50dd-d0b9-4c62-b7d3-7e90430c52fd"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1151", "75"]}]], "Output",
 CellChangeTimes->{3.971347265485551*^9},
 CellLabel->"Out[85]=",ExpressionUUID->"83db462b-b24f-429d-af2e-a41446f65a4b"]
}, Open  ]],

Cell[TextData[{
 "32. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", 
        FractionBox["3", "5"]}], 
       RowBox[{"-", 
        FractionBox["5", "4"]}], "3"},
      {
       FractionBox["5", "2"], "3", 
       RowBox[{"-", "2"}]},
      {"5", 
       RowBox[{"-", 
        FractionBox["1", "3"]}], "0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.97134710114743*^9, 3.97134711902172*^9}, 
    3.971347163868177*^9},ExpressionUUID->
  "74b7e3f3-d696-4d79-8391-21def7422e8a"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.97134716796178*^9}, {3.9713477368637466`*^9, 
   3.97134773708731*^9}},ExpressionUUID->"359f407b-f1d3-49a7-acde-\
3c7c4a278d2e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", 
        FractionBox["3", "5"]}], 
       RowBox[{"-", 
        FractionBox["5", "4"]}], "3"},
      {
       FractionBox["5", "2"], "3", 
       RowBox[{"-", "2"}]},
      {"5", 
       RowBox[{"-", 
        FractionBox["1", "3"]}], "0"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellChangeTimes->{{3.971347231383782*^9, 3.9713472372894287`*^9}},
 CellLabel->"In[86]:=",ExpressionUUID->"a50c9ff4-d106-4dfb-be43-068c72896291"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["173", "5"]}]], "Output",
 CellChangeTimes->{3.9713472693671217`*^9},
 CellLabel->"Out[86]=",ExpressionUUID->"fb10c480-8c6f-49dd-b2b7-5d99e9bce390"]
}, Open  ]],

Cell[TextData[{
 "33. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox["3", "5"], 
       RowBox[{"-", "2"}], "5"},
      {"5", 
       RowBox[{"-", "1"}], 
       FractionBox["4", "5"]},
      {
       RowBox[{"-", "4"}], 
       RowBox[{"-", 
        FractionBox["3", "4"]}], 
       RowBox[{"-", "2"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.97134710114743*^9, 3.97134711902172*^9}, {
   3.971347163868177*^9, 3.971347170884378*^9}},ExpressionUUID->
  "42aa4bbf-680e-49a7-985b-bf5e32caa1c0"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.9713471752147207`*^9}, {3.9713477404774513`*^9, 
   3.971347740595104*^9}},ExpressionUUID->"f03f893b-29c9-41dc-89c5-\
00dee92b53de"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox["3", "5"], 
       RowBox[{"-", "2"}], "5"},
      {"5", 
       RowBox[{"-", "1"}], 
       FractionBox["4", "5"]},
      {
       RowBox[{"-", "4"}], 
       RowBox[{"-", 
        FractionBox["3", "4"]}], 
       RowBox[{"-", "2"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellChangeTimes->{{3.9713472397422247`*^9, 3.971347246209031*^9}},
 CellLabel->"In[87]:=",ExpressionUUID->"50cba0b9-f089-44c8-b4c9-ddc431ec2d87"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["5079", "100"]}]], "Output",
 CellChangeTimes->{3.97134727226821*^9},
 CellLabel->"Out[87]=",ExpressionUUID->"e1fe9571-7b88-4c62-a507-dee6c772f861"]
}, Open  ]],

Cell[TextData[{
 "34. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox["2", "5"], "3", 
       RowBox[{"-", 
        FractionBox["3", "5"]}], 
       FractionBox["3", "4"]},
      {"4", 
       RowBox[{"-", "3"}], "1", "1"},
      {"1", 
       RowBox[{"-", "4"}], "0", "2"},
      {
       RowBox[{"-", "5"}], 
       RowBox[{"-", "4"}], "1", 
       RowBox[{"-", "5"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.97134710114743*^9, 3.97134711902172*^9}, {
   3.971347163868177*^9, 3.9713471822879868`*^9}},ExpressionUUID->
  "61d14916-2d6f-4936-ad8e-060f6b7b99b1"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347151472485*^9}, 3.971347187879829*^9, {
   3.971347743631362*^9, 
   3.971347743898911*^9}},ExpressionUUID->"f6aea2b3-3a3e-4dc0-b922-\
53600fe9651a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox["2", "5"], "3", 
       RowBox[{"-", 
        FractionBox["3", "5"]}], 
       FractionBox["3", "4"]},
      {"4", 
       RowBox[{"-", "3"}], "1", "1"},
      {"1", 
       RowBox[{"-", "4"}], "0", "2"},
      {
       RowBox[{"-", "5"}], 
       RowBox[{"-", "4"}], "1", 
       RowBox[{"-", "5"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellChangeTimes->{{3.971347248723261*^9, 3.971347254195126*^9}},
 CellLabel->"In[88]:=",ExpressionUUID->"f5a9ccc3-8c48-4049-8d3d-9db8f2469e0c"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["169", "20"]}]], "Output",
 CellChangeTimes->{3.971347275707788*^9},
 CellLabel->"Out[88]=",ExpressionUUID->"d0c50ec1-57c6-4499-b94a-c220e7fea80d"]
}, Open  ]],

Cell[TextData[{
 "35. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "1"}], "5", "2", "4", "4"},
      {"3", 
       RowBox[{"-", "4"}], "3", 
       RowBox[{"-", "1"}], 
       FractionBox["2", "5"]},
      {
       RowBox[{"-", "2"}], 
       FractionBox["1", "2"], 
       RowBox[{"-", 
        FractionBox["3", "2"]}], 
       RowBox[{"-", 
        FractionBox["4", "3"]}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}]},
      {
       FractionBox["1", "3"], 
       RowBox[{"-", 
        FractionBox["4", "3"]}], 
       FractionBox["5", "3"], 
       RowBox[{"-", "1"}], "3"},
      {
       RowBox[{"-", 
        FractionBox["3", "4"]}], 
       RowBox[{"-", 
        FractionBox["4", "5"]}], "5", "0", 
       RowBox[{"-", "3"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.97134710114743*^9, 3.97134711902172*^9}, {
   3.971347163868177*^9, 3.971347200281912*^9}},ExpressionUUID->
  "75dc2489-d779-413e-afcd-26b05e3eafde"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 
   3.971347748204699*^9}},ExpressionUUID->"c1a711e5-a6bd-4d54-a56f-\
302274ba2862"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "1"}], "5", "2", "4", "4"},
      {"3", 
       RowBox[{"-", "4"}], "3", 
       RowBox[{"-", "1"}], 
       FractionBox["2", "5"]},
      {
       RowBox[{"-", "2"}], 
       FractionBox["1", "2"], 
       RowBox[{"-", 
        FractionBox["3", "2"]}], 
       RowBox[{"-", 
        FractionBox["4", "3"]}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}]},
      {
       FractionBox["1", "3"], 
       RowBox[{"-", 
        FractionBox["4", "3"]}], 
       FractionBox["5", "3"], 
       RowBox[{"-", "1"}], "3"},
      {
       RowBox[{"-", 
        FractionBox["3", "4"]}], 
       RowBox[{"-", 
        FractionBox["4", "5"]}], "5", "0", 
       RowBox[{"-", "3"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellChangeTimes->{{3.9713472564171457`*^9, 3.971347261935008*^9}},
 CellLabel->"In[89]:=",ExpressionUUID->"c76bd92d-2674-4a95-a64e-aafaec2bfb87"],

Cell[BoxData[
 FractionBox["12029", "600"]], "Output",
 CellChangeTimes->{3.971347279525838*^9},
 CellLabel->"Out[89]=",ExpressionUUID->"216d3515-2bbb-4b68-8eae-0b71cc304808"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sistemas de ecuaciones por Gauss y Cramer", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.960373554907916*^9}, {
  3.960373599790991*^9, 3.960373600209758*^9}, {3.960373675327395*^9, 
  3.9603736995423307`*^9}, {3.9713408664497957`*^9, 
  3.971340866762909*^9}},ExpressionUUID->"dd427e0d-7505-4f18-8d63-\
d88a709b32df"],

Cell[TextData[{
 "36. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "1"}], "2", "4", 
       RowBox[{"-", 
        FractionBox["4", "3"]}]},
      {
       RowBox[{"-", "2"}], "4", 
       FractionBox["4", "3"], 
       RowBox[{"-", 
        FractionBox["1", "5"]}]},
      {
       RowBox[{"-", "2"}], "0", "1", "2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{3.971348941007781*^9},ExpressionUUID->
  "a6735799-2c9d-4fa4-a8f3-a5cf86da128d"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971349007075294*^9}},ExpressionUUID->"987121bb-4c03-43b7-a20d-\
ce10f23f7b64"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "1"}], "2", "4"},
       {
        RowBox[{"-", "2"}], "4", 
        FractionBox["4", "3"]},
       {
        RowBox[{"-", "2"}], "0", "1"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", 
        FractionBox["4", "3"]}]},
      {
       RowBox[{"-", 
        FractionBox["1", "5"]}]},
      {"2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.971349009269175*^9, 3.971349029053658*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"74c11ab6-c4d9-45eb-875d-86d1877e8d53"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["237", "200"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["623", "1200"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["37", "100"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9713490300300217`*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"13e8c9ca-3afa-46ca-97f2-844c36a4c64a"]
}, Open  ]],

Cell[TextData[{
 "37. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       RowBox[{"-", "2"}], "3", 
       RowBox[{"-", "3"}], "4"},
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", "5"}], "0", "3"},
      {
       RowBox[{"-", "1"}], 
       FractionBox["3", "2"], 
       RowBox[{"-", 
        FractionBox["4", "5"]}], 
       FractionBox["1", "3"]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{3.971348941007781*^9, 3.971349065495804*^9},
  ExpressionUUID->"33e26940-894c-4bd6-bc6d-dbef72fc54c6"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971348983452998*^9}, 
   3.9713490717127743`*^9},ExpressionUUID->"0facd949-fb97-4996-8b86-\
23f6dedc557b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "2"}], "3", 
        RowBox[{"-", "3"}]},
       {
        RowBox[{"-", "1"}], 
        RowBox[{"-", "5"}], "0"},
       {
        RowBox[{"-", "1"}], 
        FractionBox["3", "2"], 
        RowBox[{"-", 
         FractionBox["4", "5"]}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"(", GridBox[{
      {"4"},
      {"3"},
      {
       FractionBox["1", "3"]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.971349043504271*^9, 3.971349080224799*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"f9d0aa3a-ee95-43b4-8386-6c635d6765a8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    FractionBox["47", "91"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["64", "91"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["50", "21"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.971349081519815*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"e9542b01-c205-4f2a-a852-d712a7e2ac2c"]
}, Open  ]],

Cell[TextData[{
 "38. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"3", "5", "3", 
       RowBox[{"-", 
        FractionBox["2", "3"]}]},
      {
       FractionBox["2", "5"], "1", "4", "4"},
      {
       RowBox[{"-", "1"}], 
       RowBox[{"-", 
        FractionBox["5", "2"]}], 
       RowBox[{"-", "5"}], 
       RowBox[{"-", "4"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{
   3.971348941007781*^9, {3.971349065495804*^9, 3.971349099891962*^9}},
  ExpressionUUID->"c30ea721-a321-4286-864a-db1b0a39316f"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971348986423646*^9}, 
   3.9713491055322027`*^9},ExpressionUUID->"b7a9c1ae-e807-4ef7-9711-\
acd158a91620"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"3", "5", "3"},
       {
        FractionBox["2", "5"], "1", "4"},
       {
        RowBox[{"-", "1"}], 
        RowBox[{"-", 
         FractionBox["5", "2"]}], 
        RowBox[{"-", "5"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"(", GridBox[{
      {
       RowBox[{"-", 
        FractionBox["2", "3"]}]},
      {"4"},
      {
       RowBox[{"-", "4"}]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.971349109790303*^9, 3.971349114425724*^9}},
 CellLabel->
  "In[116]:=",ExpressionUUID->"99c6cbcb-1de7-41d3-b96a-09ea55fa1759"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["4", "15"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["52", "75"]}], "}"}], ",", 
   RowBox[{"{", 
    FractionBox["6", "5"], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.971349116255669*^9},
 CellLabel->
  "Out[116]=",ExpressionUUID->"e5d123a6-8715-48fe-a88e-38ff01072a56"]
}, Open  ]],

Cell[TextData[{
 "39. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox["5", "4"], "3", 
       RowBox[{"-", "4"}], 
       FractionBox["1", "2"], "2"},
      {
       FractionBox["5", "4"], "1", 
       RowBox[{"-", 
        FractionBox["3", "2"]}], "3", 
       FractionBox["1", "4"]},
      {"3", 
       RowBox[{"-", "2"}], 
       RowBox[{"-", "1"}], 
       RowBox[{"-", "4"}], "4"},
      {
       RowBox[{"-", 
        FractionBox["3", "2"]}], "3", 
       FractionBox["1", "4"], 
       RowBox[{"-", "3"}], "2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{
   3.971348941007781*^9, {3.971349065495804*^9, 3.9713491255966377`*^9}},
  ExpressionUUID->"096712a5-eaec-4adb-8984-ad7f2eb35e7f"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.9713489902630796`*^9}, 
   3.9713491321330423`*^9},ExpressionUUID->"7bd38838-49a2-4ee3-a6af-\
db9dec97ce97"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["5", "4"], "3", 
        RowBox[{"-", "4"}], 
        FractionBox["1", "2"]},
       {
        FractionBox["5", "4"], "1", 
        RowBox[{"-", 
         FractionBox["3", "2"]}], "3"},
       {"3", 
        RowBox[{"-", "2"}], 
        RowBox[{"-", "1"}], 
        RowBox[{"-", "4"}]},
       {
        RowBox[{"-", 
         FractionBox["3", "2"]}], "3", 
        FractionBox["1", "4"], 
        RowBox[{"-", "3"}]}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"(", GridBox[{
      {"2"},
      {
       FractionBox["1", "4"]},
      {"4"},
      {"2"}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.97134913491498*^9, 3.971349140149849*^9}},
 CellLabel->
  "In[118]:=",ExpressionUUID->"bec9fe43-a0ef-4294-a203-ad45ba139831"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    FractionBox["215", "163"], "}"}], ",", 
   RowBox[{"{", 
    FractionBox["2799", "3586"], "}"}], ",", 
   RowBox[{"{", 
    FractionBox["778", "1793"], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["1827", "3586"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.971349141443109*^9},
 CellLabel->
  "Out[118]=",ExpressionUUID->"c8d3b156-a473-4e86-b9e4-f683fb221607"]
}, Open  ]],

Cell[TextData[{
 "40. ",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       FractionBox["4", "5"], 
       RowBox[{"-", "2"}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}], "0"},
      {
       RowBox[{"-", "2"}], "2", "1", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], "5"},
      {
       RowBox[{"-", "2"}], 
       RowBox[{"-", 
        FractionBox["1", "2"]}], "4", 
       RowBox[{"-", "3"}], 
       FractionBox["1", "3"]},
      {
       RowBox[{"-", "2"}], "0", "5", "0", 
       FractionBox["1", "3"]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{
   3.971348941007781*^9, {3.971349065495804*^9, 3.971349146404303*^9}},
  ExpressionUUID->"2a7dfa82-b72f-4afe-a12b-1749b274b5f3"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971348994030554*^9}, 
   3.9713491527240353`*^9},ExpressionUUID->"c4696c1b-ba43-496e-9061-\
e0a3f38bbdf1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        FractionBox["4", "5"], 
        RowBox[{"-", "2"}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}]},
       {
        RowBox[{"-", "2"}], "2", "1", 
        RowBox[{"-", 
         FractionBox["1", "2"]}]},
       {
        RowBox[{"-", "2"}], 
        RowBox[{"-", 
         FractionBox["1", "2"]}], "4", 
        RowBox[{"-", "3"}]},
       {
        RowBox[{"-", "2"}], "0", "5", "0"}
      },
      GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   RowBox[{"(", GridBox[{
      {"0"},
      {"5"},
      {
       FractionBox["1", "3"]},
      {
       FractionBox["1", "3"]}
     },
     GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.971349155256255*^9, 3.971349160204268*^9}},
 CellLabel->
  "In[120]:=",ExpressionUUID->"631044c1-63a6-4467-8299-2b2aba8c9447"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["3413", "558"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["2984", "1395"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", 
     FractionBox["664", "279"]}], "}"}], ",", 
   RowBox[{"{", 
    FractionBox["1604", "1395"], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9713491610599127`*^9},
 CellLabel->
  "Out[120]=",ExpressionUUID->"eb37c640-5788-4906-b6d8-3b5203f86416"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicios con par\[AAcute]metros", "Section",
 CellChangeTimes->{{3.9603733470613728`*^9, 3.960373569338501*^9}, {
  3.9603736031065283`*^9, 3.960373603645134*^9}, {3.960373675327693*^9, 
  3.960373704942679*^9}, {3.971340869433855*^9, 
  3.971340869777438*^9}},ExpressionUUID->"e84e0b9f-175f-4f33-a576-\
619df22977c4"],

Cell[TextData[{
 "41. ",
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "k", "0", "0"},
     {"0", "1", "k", "0"},
     {"k", "0", "1", "0"}
    }], "\[NoBreak]", ")"}]],
  CellChangeTimes->{{3.9713517491944447`*^9, 3.971351764536948*^9}},
  ExpressionUUID->"375d1624-16a8-47e0-9350-8b9d8f0c6b6e"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971349007075294*^9}, {3.971351694716889*^9, 3.971351698553094*^9}, 
   3.971351769142263*^9},ExpressionUUID->"8aa888f1-d78c-4e6a-a04e-\
79f54f6ac1c1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "k", "0"},
        {"0", "1", "k"},
        {"k", "0", "1"}
       }], "\[NoBreak]", ")"}], "]"}], "==", "0"}], ",", "k", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9713517491944447`*^9, 3.971351764536948*^9}, {
  3.9713521099406443`*^9, 3.971352132986877*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"69a84945-bc16-4020-aff6-7add6fe1fc7d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"k", "\[Rule]", 
    RowBox[{"-", "1"}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.9713521278605843`*^9, 3.971352133712706*^9}},
 CellLabel->
  "Out[122]=",ExpressionUUID->"92d6eec6-c7f5-4184-94d1-a244bc78fb0e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "k", "0", "0"},
       {"0", "1", "k", "0"},
       {"k", "0", "1", "0"}
      }], "\[NoBreak]", ")"}], "/.", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971352145858488*^9, 3.97135217082843*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"19c613bf-4dd1-44a7-ab3e-e2df9542d005"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      RowBox[{"-", "1"}], "0"},
     {"0", "1", 
      RowBox[{"-", "1"}], "0"},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.971352165737447*^9, 3.9713521715568*^9}},
 CellLabel->
  "Out[124]//MatrixForm=",ExpressionUUID->"95b03527-067e-43d4-b718-\
a5773dca59ca"]
}, Open  ]],

Cell[TextData[{
 "42. ",
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"k", "1", "2", "1"},
     {"1", "k", "3", "0"},
     {"2", "3", "k", 
      RowBox[{"-", "1"}]}
    }], "\[NoBreak]", ")"}]],
  CellChangeTimes->{{3.9713517491944447`*^9, 3.971351764536948*^9}},
  ExpressionUUID->"8fecb9e8-a30d-45a2-976d-398889dabdb3"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971349007075294*^9}, {3.971351694716889*^9, 3.97135170707292*^9}, {
   3.971351776559567*^9, 
   3.9713518098447638`*^9}},ExpressionUUID->"8bd25e6b-4ff6-4310-abbf-\
93fedfd1a6fd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"k", "1", "2"},
        {"1", "k", "3"},
        {"2", "3", "k"}
       }], "\[NoBreak]", ")"}], "]"}], "==", "0"}], ",", "k", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9713517491944447`*^9, 3.971351764536948*^9}, {
  3.9713521099406443`*^9, 3.971352132986877*^9}, {3.971352326492395*^9, 
  3.971352362169882*^9}},
 CellLabel->
  "In[127]:=",ExpressionUUID->"7ce457a1-35ac-4cc4-b9e0-8a94c38cae7e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-4.11\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -4.11309058432495078250212827697396278381`15.\
954589770191003, Editable -> False], "approx" -> -4.113090584324951, "interp" -> 
       InterpretationBox["", 
         Root[12 - 14 # + #^3& , 1, 0]], "head" -> "Root", "big" -> RowBox[{
          RowBox[{"12", "-", 
            RowBox[{"14", " ", "#1"}], "+", 
            SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
       "shortDegree" -> "3", "number" -> 1|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.911\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.91117880764624303857601717027137055993`15.954589770191003, 
         Editable -> False], "approx" -> 0.911178807646243, "interp" -> 
       InterpretationBox["", 
         Root[12 - 14 # + #^3& , 2, 0]], "head" -> "Root", "big" -> RowBox[{
          RowBox[{"12", "-", 
            RowBox[{"14", " ", "#1"}], "+", 
            SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
       "shortDegree" -> "3", "number" -> 2|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"3.20\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         3.20191177667870796597071603173390030861`15.954589770191003, 
         Editable -> False], "approx" -> 3.201911776678708, "interp" -> 
       InterpretationBox["", 
         Root[12 - 14 # + #^3& , 3, 0]], "head" -> "Root", "big" -> RowBox[{
          RowBox[{"12", "-", 
            RowBox[{"14", " ", "#1"}], "+", 
            SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
       "shortDegree" -> "3", "number" -> 3|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.971352329937694*^9, 3.971352362530307*^9}},
 CellLabel->
  "Out[127]=",ExpressionUUID->"e89aef64-0798-4469-a480-f7764a2cd638"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"k", "1", "2"},
        {"1", "k", "3"},
        {"2", "3", "k"}
       }], "\[NoBreak]", ")"}], "]"}], "==", "0"}], ",", "k", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.9713526417437143`*^9},
 CellLabel->
  "In[145]:=",ExpressionUUID->"5fe2b690-a5a6-4ca2-bf93-5ce1466c645b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"-", "4.113090584324952`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", "0.911178807646243`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", "3.2019117766787084`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.971352642683057*^9, 3.971353091352466*^9},
 CellLabel->
  "Out[145]=",ExpressionUUID->"e1fc3b13-a0fe-46c2-9dc2-a0649c6ec9ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"k", "1", "2", "1"},
       {"1", "k", "3", "0"},
       {"2", "3", "k", 
        RowBox[{"-", "1"}]}
      }], "\[NoBreak]", ")"}], "/.", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-4.11\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -4.11309058432495078250212827697396278381`15.\
954589770191003, Editable -> False], "approx" -> -4.113090584324951, "interp" -> 
       InterpretationBox["", 
         Root[12 - 14 # + #^3& , 1, 0]], "head" -> "Root", "big" -> RowBox[{
          RowBox[{"12", "-", 
            RowBox[{"14", " ", "#1"}], "+", 
            SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
       "shortDegree" -> "3", "number" -> 1|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971352145858488*^9, 3.97135217082843*^9}, 
   3.971352373395834*^9, 3.9713524105391912`*^9},
 CellLabel->
  "In[128]:=",ExpressionUUID->"6a6773f3-b4a7-48be-aca7-d18d7af74108"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "9"}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-4.11\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -4.11309058432495167068054797709919512272`15.\
954589770191003, Editable -> False], "approx" -> -4.113090584324952, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 1, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}], 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"2", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-4.11\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -4.11309058432495167068054797709919512272`15.\
954589770191003, Editable -> False], "approx" -> -4.113090584324952, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 1, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}]}]], "0"},
     {"0", "1", 
      FractionBox[
       RowBox[{"6", "-", 
        TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
            StyleBox[
             TemplateBox[{"\"-4.11\"", 
               DynamicBox[
                FEPrivate`FrontEndResource[
                "FEExpressions", "NumericalApproximationElider"]]}, 
              "RowDefault"], ShowStringCharacters -> 
             False], -4.11309058432495167068054797709919512272`15.\
954589770191003, Editable -> False], "approx" -> -4.113090584324952, "interp" -> 
          InterpretationBox["", 
            Root[12 - 14 # + #^3& , 1, 0]], "head" -> "Root", "big" -> RowBox[{
             RowBox[{"12", "-", 
               RowBox[{"14", " ", "#1"}], "+", 
               SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
          "shortDegree" -> "3", "number" -> 1|>,
         "NumericalApproximationInterp",
         InterpretationFunction->(Slot["interp"]& )]}], 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"2", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-4.11\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -4.11309058432495167068054797709919512272`15.\
954589770191003, Editable -> False], "approx" -> -4.113090584324952, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 1, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}]}]], "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971352417470131*^9},
 CellLabel->
  "Out[128]//MatrixForm=",ExpressionUUID->"81948c6a-a153-4de5-9d66-\
4870df3dc1f8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"k", "1", "2", "1"},
       {"1", "k", "3", "0"},
       {"2", "3", "k", 
        RowBox[{"-", "1"}]}
      }], "\[NoBreak]", ")"}], "/.", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"0.911\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         0.91117880764624303857601717027137055993`15.954589770191003, 
         Editable -> False], "approx" -> 0.911178807646243, "interp" -> 
       InterpretationBox["", 
         Root[12 - 14 # + #^3& , 2, 0]], "head" -> "Root", "big" -> RowBox[{
          RowBox[{"12", "-", 
            RowBox[{"14", " ", "#1"}], "+", 
            SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
       "shortDegree" -> "3", "number" -> 2|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971352387812498*^9, 3.9713524127382*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"d8353be2-977b-462a-82aa-73b42333cf8f"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "9"}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"0.911\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> False], 
             0.91117880764624303857601717027137055993`15.954589770191003, 
             Editable -> False], "approx" -> 0.911178807646243, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 2, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}], 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"2", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"0.911\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> False], 
             0.91117880764624303857601717027137055993`15.954589770191003, 
             Editable -> False], "approx" -> 0.911178807646243, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 2, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}]}]], "0"},
     {"0", "1", 
      FractionBox[
       RowBox[{"6", "-", 
        TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
            StyleBox[
             TemplateBox[{"\"0.911\"", 
               DynamicBox[
                FEPrivate`FrontEndResource[
                "FEExpressions", "NumericalApproximationElider"]]}, 
              "RowDefault"], ShowStringCharacters -> False], 
            0.91117880764624303857601717027137055993`15.954589770191003, 
            Editable -> False], "approx" -> 0.911178807646243, "interp" -> 
          InterpretationBox["", 
            Root[12 - 14 # + #^3& , 2, 0]], "head" -> "Root", "big" -> RowBox[{
             RowBox[{"12", "-", 
               RowBox[{"14", " ", "#1"}], "+", 
               SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
          "shortDegree" -> "3", "number" -> 2|>,
         "NumericalApproximationInterp",
         InterpretationFunction->(Slot["interp"]& )]}], 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"2", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"0.911\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> False], 
             0.91117880764624303857601717027137055993`15.954589770191003, 
             Editable -> False], "approx" -> 0.911178807646243, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 2, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}]}]], "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971352424309273*^9},
 CellLabel->
  "Out[129]//MatrixForm=",ExpressionUUID->"906cb22f-c8da-4917-b203-\
303793483d66"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"k", "1", "2", "1"},
       {"1", "k", "3", "0"},
       {"2", "3", "k", 
        RowBox[{"-", "1"}]}
      }], "\[NoBreak]", ")"}], "/.", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"3.20\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> False], 
         3.20191177667870796597071603173390030861`15.954589770191003, 
         Editable -> False], "approx" -> 3.201911776678708, "interp" -> 
       InterpretationBox["", 
         Root[12 - 14 # + #^3& , 3, 0]], "head" -> "Root", "big" -> RowBox[{
          RowBox[{"12", "-", 
            RowBox[{"14", " ", "#1"}], "+", 
            SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
       "shortDegree" -> "3", "number" -> 3|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971352399467681*^9, 3.9713524153732367`*^9}},
 CellLabel->
  "In[130]:=",ExpressionUUID->"e55c2dc3-0b15-4b36-b8ca-dfff11177717"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "9"}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"3.20\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> False], 
             3.20191177667870841005992588179651647806`15.954589770191003, 
             Editable -> False], "approx" -> 3.2019117766787084`, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 3, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 3|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}], 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"2", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"3.20\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> False], 
             3.20191177667870841005992588179651647806`15.954589770191003, 
             Editable -> False], "approx" -> 3.2019117766787084`, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 3, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 3|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}]}]], "0"},
     {"0", "1", 
      FractionBox[
       RowBox[{"6", "-", 
        TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
            StyleBox[
             TemplateBox[{"\"3.20\"", 
               DynamicBox[
                FEPrivate`FrontEndResource[
                "FEExpressions", "NumericalApproximationElider"]]}, 
              "RowDefault"], ShowStringCharacters -> False], 
            3.20191177667870841005992588179651647806`15.954589770191003, 
            Editable -> False], "approx" -> 3.2019117766787084`, "interp" -> 
          InterpretationBox["", 
            Root[12 - 14 # + #^3& , 3, 0]], "head" -> "Root", "big" -> RowBox[{
             RowBox[{"12", "-", 
               RowBox[{"14", " ", "#1"}], "+", 
               SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
          "shortDegree" -> "3", "number" -> 3|>,
         "NumericalApproximationInterp",
         InterpretationFunction->(Slot["interp"]& )]}], 
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"2", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"3.20\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> False], 
             3.20191177667870841005992588179651647806`15.954589770191003, 
             Editable -> False], "approx" -> 3.2019117766787084`, "interp" -> 
           InterpretationBox["", 
             Root[12 - 14 # + #^3& , 3, 0]], "head" -> "Root", "big" -> 
           RowBox[{
              RowBox[{"12", "-", 
                RowBox[{"14", " ", "#1"}], "+", 
                SuperscriptBox["#1", "3"]}], "&"}], "degree" -> "3", 
           "shortDegree" -> "3", "number" -> 3|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}]}]], "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971352429948296*^9},
 CellLabel->
  "Out[130]//MatrixForm=",ExpressionUUID->"8a10a728-c3f5-4b05-9781-\
3da251b98a8d"]
}, Open  ]],

Cell[TextData[{
 "43. ",
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "1"},
     {"2", "4", "6", "2"},
     {"1", "k", "1", "t"}
    }], "\[NoBreak]", ")"}]],
  CellChangeTimes->{{3.9713517491944447`*^9, 3.971351764536948*^9}},
  ExpressionUUID->"68651499-f1ce-479f-aec9-32b337ca20a2"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971349007075294*^9}, {3.971351694716889*^9, 3.9713517095029383`*^9}, {
   3.971351814120584*^9, 
   3.971351855664469*^9}},ExpressionUUID->"a24545b1-23f3-476e-b638-\
afa1096ff4b0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "2", "3"},
        {"2", "4", "6"},
        {"1", "k", "1"}
       }], "\[NoBreak]", ")"}], "]"}], "==", "0"}], ",", "k"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9713517491944447`*^9, 3.971351764536948*^9}, {
  3.9713521099406443`*^9, 3.971352132986877*^9}, {3.9713528074505*^9, 
  3.97135282490101*^9}},
 CellLabel->
  "In[137]:=",ExpressionUUID->"9224dc90-15f2-4467-9ba3-a44f44433ce3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.971352812927656*^9, 3.971352825906337*^9}, 
   3.971352921194167*^9},
 CellLabel->
  "Out[137]=",ExpressionUUID->"d691437c-4c80-4d10-872b-b622f1dd3868"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3"},
     {"2", "4", "6"},
     {"1", "k", "1"}
    }], "\[NoBreak]", ")"}], "]"}]], "Input",
 CellLabel->
  "In[135]:=",ExpressionUUID->"c9430741-0bc3-4be2-9c87-36078896e6b3"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.971352836217771*^9, 3.971352851039139*^9}},
 CellLabel->
  "Out[135]=",ExpressionUUID->"f78e9573-ef7c-4eff-84d2-b38d916236ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", 
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"1", "2", "3", "1"},
      {"2", "4", "6", "2"},
      {"1", "k", "1", "t"}
     }], "\[NoBreak]", ")"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971352145858488*^9, 3.97135217082843*^9}, 
   3.971352881419181*^9},
 CellLabel->
  "In[136]:=",ExpressionUUID->"ccb1465b-f749-4887-9c70-25042c41a263"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"3", " ", "k"}]}], 
       RowBox[{
        RowBox[{"-", "2"}], "+", "k"}]], 
      FractionBox[
       RowBox[{"k", "-", 
        RowBox[{"2", " ", "t"}]}], 
       RowBox[{
        RowBox[{"-", "2"}], "+", "k"}]]},
     {"0", "1", 
      RowBox[{"-", 
       FractionBox["2", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "k"}]]}], 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "t"}], 
       RowBox[{
        RowBox[{"-", "2"}], "+", "k"}]]},
     {"0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971352882878655*^9},
 CellLabel->
  "Out[136]//MatrixForm=",ExpressionUUID->"53bec579-bee0-4139-bf46-\
a4858f1279d6"]
}, Open  ]],

Cell[TextData[{
 "44. ",
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "k", "0", "1"},
     {"0", "1", "2", "k", "0"},
     {"k", "0", "1", "2", "0"},
     {"2", "k", "0", "1", "1"}
    }], "\[NoBreak]", ")"}]],ExpressionUUID->
  "b9f9bf8e-37f2-4ed7-a272-f149bf6e9f12"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971349007075294*^9}, {3.971351694716889*^9, 3.971351712055531*^9}, {
   3.971351859631052*^9, 
   3.9713519493494987`*^9}},ExpressionUUID->"2d487a37-6b54-4cb4-9047-\
c4d5ac1d8def"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"1", "2", "k", "0"},
        {"0", "1", "2", "k"},
        {"k", "0", "1", "2"},
        {"2", "k", "0", "1"}
       }], ")"}], "]"}], "==", "0"}], ",", "k", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9713517491944447`*^9, 3.971351764536948*^9}, {
   3.9713521099406443`*^9, 3.971352132986877*^9}, 3.971352941475419*^9},
 CellLabel->
  "In[138]:=",ExpressionUUID->"f3c0b1b6-02fd-49a1-9d86-894c76411cdc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9713529430891027`*^9},
 CellLabel->
  "Out[138]=",ExpressionUUID->"b7ae9ab1-293d-4e88-aba7-1940b9f3b301"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2", "k", "0", "1"},
       {"0", "1", "2", "k", "0"},
       {"k", "0", "1", "2", "0"},
       {"2", "k", "0", "1", "1"}
      }], "\[NoBreak]", ")"}], "/.", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"-", "3"}]}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971352145858488*^9, 3.97135217082843*^9}, {
  3.971352953721381*^9, 3.971352956649539*^9}},
 CellLabel->
  "In[139]:=",ExpressionUUID->"fec3e112-e67e-44dd-ba7b-65a56301412e"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", 
      RowBox[{"-", "1"}], "0"},
     {"0", "1", "0", 
      RowBox[{"-", "1"}], "0"},
     {"0", "0", "1", 
      RowBox[{"-", "1"}], "0"},
     {"0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9713529570706453`*^9},
 CellLabel->
  "Out[139]//MatrixForm=",ExpressionUUID->"c66f0354-a5f4-4c25-a39c-\
23658745ba4c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2", "k", "0", "1"},
       {"0", "1", "2", "k", "0"},
       {"k", "0", "1", "2", "0"},
       {"2", "k", "0", "1", "1"}
      }], "\[NoBreak]", ")"}], "/.", 
    RowBox[{"k", "\[Rule]", "1"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellChangeTimes->{3.971352967346678*^9},
 CellLabel->
  "In[140]:=",ExpressionUUID->"cec709e2-c42b-443a-b933-d4242739a7bd"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "1", 
      FractionBox["1", "4"]},
     {"0", "1", "0", 
      RowBox[{"-", "1"}], 
      FractionBox["1", "2"]},
     {"0", "0", "1", "1", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]},
     {"0", "0", "0", "0", "0"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971352967754813*^9},
 CellLabel->
  "Out[140]//MatrixForm=",ExpressionUUID->"ea966651-dfdb-4550-a9b5-\
2509db5c03c4"]
}, Open  ]],

Cell[TextData[{
 "45. ",
 Cell[BoxData[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"k", "+", "1"}], "2", 
      RowBox[{"-", "1"}], "3", "1"},
     {"1", 
      RowBox[{"k", "-", "2"}], "4", 
      RowBox[{"-", "1"}], "0"},
     {"2", 
      RowBox[{"-", "3"}], "k", "5", "0"},
     {
      RowBox[{"-", "1"}], "4", "2", 
      RowBox[{"k", "+", "2"}], "1"}
    }], "\[NoBreak]", ")"}]],ExpressionUUID->
  "e14416f4-9068-40e2-bdff-79e59bb65539"]
}], "Text",
 CellChangeTimes->{{3.960389567104969*^9, 3.9603896733180904`*^9}, {
   3.960390002460264*^9, 3.960390026680338*^9}, {3.960390127207079*^9, 
   3.960390340315693*^9}, {3.960390422719673*^9, 3.9603904595713825`*^9}, {
   3.9603905378717537`*^9, 3.960390539447508*^9}, {3.960391900061718*^9, 
   3.960391971892025*^9}, {3.9711967070736856`*^9, 3.9711967558229847`*^9}, {
   3.971196809707883*^9, 3.9711968477496853`*^9}, {3.9711969256495543`*^9, 
   3.971196938025148*^9}, {3.971264615016705*^9, 3.971264680056445*^9}, {
   3.971264966870618*^9, 3.9712650214110813`*^9}, {3.971265245405401*^9, 
   3.971265303535017*^9}, 3.971267098224958*^9, 3.971267654217277*^9, {
   3.971268289268394*^9, 3.971268391286427*^9}, {3.971341176472773*^9, 
   3.9713412131594753`*^9}, 3.9713416275147743`*^9, {3.971341746054195*^9, 
   3.971341749113512*^9}, {3.971344006771496*^9, 3.971344038568184*^9}, {
   3.971347134797102*^9, 3.971347154402223*^9}, 3.971347208997842*^9, {
   3.971347747933321*^9, 3.971347748204699*^9}, {3.971348970646105*^9, 
   3.971349007075294*^9}, {3.971351694716889*^9, 3.971351714542986*^9}, {
   3.971351955619574*^9, 
   3.971352027936427*^9}},ExpressionUUID->"cf31c79d-c443-4d52-9333-\
317fa066321c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{"k", "+", "1"}], "2", 
         RowBox[{"-", "1"}], "3"},
        {"1", 
         RowBox[{"k", "-", "2"}], "4", 
         RowBox[{"-", "1"}]},
        {"2", 
         RowBox[{"-", "3"}], "k", "5"},
        {
         RowBox[{"-", "1"}], "4", "2", 
         RowBox[{"k", "+", "2"}]}
       }], "\[NoBreak]", ")"}], "]"}], "==", "0"}], ",", "k", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.9713517491944447`*^9, 3.971351764536948*^9}, {
  3.9713521099406443`*^9, 3.971352132986877*^9}, {3.971352980431817*^9, 
  3.971352999557847*^9}},
 CellLabel->
  "In[141]:=",ExpressionUUID->"e753c1d9-9eb3-4aba-8d01-cf8390cf405e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-5.18\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
       InterpretationBox["", 
         Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root", 
       "big" -> RowBox[{
          RowBox[{"177", "+", 
            RowBox[{"172", " ", "#1"}], "+", 
            RowBox[{"5", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
            SuperscriptBox["#1", "3"], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
       "shortDegree" -> "4", "number" -> 1|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-1.06\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
       InterpretationBox["", 
         Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root", 
       "big" -> RowBox[{
          RowBox[{"177", "+", 
            RowBox[{"172", " ", "#1"}], "+", 
            RowBox[{"5", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
            SuperscriptBox["#1", "3"], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
       "shortDegree" -> "4", "number" -> 2|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.971353001745195*^9},
 CellLabel->
  "Out[141]=",ExpressionUUID->"d2243742-b577-4519-99bb-49a60d5b7839"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {
         RowBox[{"k", "+", "1"}], "2", 
         RowBox[{"-", "1"}], "3"},
        {"1", 
         RowBox[{"k", "-", "2"}], "4", 
         RowBox[{"-", "1"}]},
        {"2", 
         RowBox[{"-", "3"}], "k", "5"},
        {
         RowBox[{"-", "1"}], "4", "2", 
         RowBox[{"k", "+", "2"}]}
       }], "\[NoBreak]", ")"}], "]"}], "==", "0"}], ",", "k", ",", "Reals"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.971353076376042*^9},
 CellLabel->
  "In[144]:=",ExpressionUUID->"4085b57e-bd0d-432c-aea3-9d67e89d59bc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"-", "5.176651720291255`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", "\[Rule]", 
     RowBox[{"-", "1.062309319393699`"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.971353076908802*^9},
 CellLabel->
  "Out[144]=",ExpressionUUID->"ea88e2ac-990f-4898-91f5-14fa395a012c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", " ", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"k", "+", "1"}], "2", 
        RowBox[{"-", "1"}], "3", "1"},
       {"1", 
        RowBox[{"k", "-", "2"}], "4", 
        RowBox[{"-", "1"}], "0"},
       {"2", 
        RowBox[{"-", "3"}], "k", "5", "0"},
       {
        RowBox[{"-", "1"}], "4", "2", 
        RowBox[{"k", "+", "2"}], "1"}
      }], "\[NoBreak]", ")"}], "/.", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-5.18\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
       InterpretationBox["", 
         Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root", 
       "big" -> RowBox[{
          RowBox[{"177", "+", 
            RowBox[{"172", " ", "#1"}], "+", 
            RowBox[{"5", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
            SuperscriptBox["#1", "3"], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
       "shortDegree" -> "4", "number" -> 1|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.971352145858488*^9, 3.97135217082843*^9}, {
  3.971353010463492*^9, 3.9713530270434504`*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"69f04cc7-4c49-403d-87b3-ca09bc6e7a36"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "130"}], "-", 
        RowBox[{"2", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "-", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "3"]}], 
       RowBox[{
        RowBox[{"-", "22"}], "+", 
        RowBox[{"6", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}]], "0"},
     {"0", "1", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "50"}], "-", 
        RowBox[{"7", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}], 
       RowBox[{
        RowBox[{"-", "22"}], "+", 
        RowBox[{"6", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}]], "0"},
     {"0", "0", "1", 
      FractionBox[
       RowBox[{"13", "+", 
        RowBox[{"8", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
              StyleBox[
               TemplateBox[{"\"-5.18\"", 
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEExpressions", "NumericalApproximationElider"]]}, 
                "RowDefault"], ShowStringCharacters -> 
               False], \
-5.17665172029125475461341920890845358372`15.954589770191003, Editable -> 
              False], "approx" -> -5.176651720291255, "interp" -> 
            InterpretationBox["", 
              Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> 
            "Root", "big" -> RowBox[{
               RowBox[{"177", "+", 
                 RowBox[{"172", " ", "#1"}], "+", 
                 RowBox[{"5", " ", 
                   SuperscriptBox["#1", "2"]}], "+", 
                 SuperscriptBox["#1", "3"], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
            "shortDegree" -> "4", "number" -> 1|>,
           "NumericalApproximationInterp",
           InterpretationFunction->(Slot["interp"]& )], "2"]}]}], 
       RowBox[{
        RowBox[{"-", "22"}], "+", 
        RowBox[{"6", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-5.18\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -5.17665172029125475461341920890845358372`15.\
954589770191003, Editable -> False], "approx" -> -5.176651720291255, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 1, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 1|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}]], "0"},
     {"0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.971353043580344*^9},
 CellLabel->
  "Out[143]//MatrixForm=",ExpressionUUID->"681a0c30-0969-4fd2-8161-\
610a5deacec3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowReduce", "[", " ", 
   RowBox[{
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"k", "+", "1"}], "2", 
        RowBox[{"-", "1"}], "3", "1"},
       {"1", 
        RowBox[{"k", "-", "2"}], "4", 
        RowBox[{"-", "1"}], "0"},
       {"2", 
        RowBox[{"-", "3"}], "k", "5", "0"},
       {
        RowBox[{"-", "1"}], "4", "2", 
        RowBox[{"k", "+", "2"}], "1"}
      }], "\[NoBreak]", ")"}], "/.", 
    RowBox[{"k", "\[Rule]", 
     TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
         StyleBox[
          TemplateBox[{"\"-1.06\"", 
            DynamicBox[
             FEPrivate`FrontEndResource[
             "FEExpressions", "NumericalApproximationElider"]]}, 
           "RowDefault"], ShowStringCharacters -> 
          False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
       InterpretationBox["", 
         Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root", 
       "big" -> RowBox[{
          RowBox[{"177", "+", 
            RowBox[{"172", " ", "#1"}], "+", 
            RowBox[{"5", " ", 
              SuperscriptBox["#1", "2"]}], "+", 
            SuperscriptBox["#1", "3"], "+", 
            SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
       "shortDegree" -> "4", "number" -> 2|>,
      "NumericalApproximationInterp",
      InterpretationFunction->(Slot["interp"]& )]}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.9713530370576143`*^9, 3.971353037397581*^9}},
 CellLabel->
  "In[142]:=",ExpressionUUID->"11095802-198d-4163-9fb2-3b45626aa205"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "130"}], "-", 
        RowBox[{"2", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "-", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "3"]}], 
       RowBox[{
        RowBox[{"-", "22"}], "+", 
        RowBox[{"6", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}]], "0"},
     {"0", "1", "0", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "50"}], "-", 
        RowBox[{"7", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}], 
       RowBox[{
        RowBox[{"-", "22"}], "+", 
        RowBox[{"6", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}]], "0"},
     {"0", "0", "1", 
      FractionBox[
       RowBox[{"13", "+", 
        RowBox[{"8", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
              StyleBox[
               TemplateBox[{"\"-1.06\"", 
                 DynamicBox[
                  FEPrivate`FrontEndResource[
                  "FEExpressions", "NumericalApproximationElider"]]}, 
                "RowDefault"], ShowStringCharacters -> 
               False], \
-1.06230931939369899197345148422755300999`15.954589770191003, Editable -> 
              False], "approx" -> -1.062309319393699, "interp" -> 
            InterpretationBox["", 
              Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> 
            "Root", "big" -> RowBox[{
               RowBox[{"177", "+", 
                 RowBox[{"172", " ", "#1"}], "+", 
                 RowBox[{"5", " ", 
                   SuperscriptBox["#1", "2"]}], "+", 
                 SuperscriptBox["#1", "3"], "+", 
                 SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
            "shortDegree" -> "4", "number" -> 2|>,
           "NumericalApproximationInterp",
           InterpretationFunction->(Slot["interp"]& )], "2"]}]}], 
       RowBox[{
        RowBox[{"-", "22"}], "+", 
        RowBox[{"6", " ", 
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )]}], "+", 
        SuperscriptBox[
         TemplateBox[<|"icon" -> "Root", "small" -> InterpretationBox[
             StyleBox[
              TemplateBox[{"\"-1.06\"", 
                DynamicBox[
                 FEPrivate`FrontEndResource[
                 "FEExpressions", "NumericalApproximationElider"]]}, 
               "RowDefault"], ShowStringCharacters -> 
              False], -1.06230931939369899197345148422755300999`15.\
954589770191003, Editable -> False], "approx" -> -1.062309319393699, "interp" -> 
           InterpretationBox["", 
             Root[177 + 172 # + 5 #^2 + #^3 + #^4& , 2, 0]], "head" -> "Root",
            "big" -> RowBox[{
              RowBox[{"177", "+", 
                RowBox[{"172", " ", "#1"}], "+", 
                RowBox[{"5", " ", 
                  SuperscriptBox["#1", "2"]}], "+", 
                SuperscriptBox["#1", "3"], "+", 
                SuperscriptBox["#1", "4"]}], "&"}], "degree" -> "4", 
           "shortDegree" -> "4", "number" -> 2|>,
          "NumericalApproximationInterp",
          InterpretationFunction->(Slot["interp"]& )], "2"]}]], "0"},
     {"0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.9713530384302073`*^9},
 CellLabel->
  "Out[142]//MatrixForm=",ExpressionUUID->"3cca7844-913f-4c4b-9f54-\
828bfc9e6e5d"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1409, 745},
WindowMargins->{{Automatic, 84}, {-43, Automatic}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"a618032d-bada-ec4d-bffa-b877020a27a6"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 199, 3, 73, "Input",ExpressionUUID->"1b1a1a17-883a-ba40-b720-b30927f5d099"],
Cell[778, 27, 1271, 34, 107, "Print",ExpressionUUID->"aba832aa-6ad4-4700-8cb5-c3bf99825b0f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2086, 66, 394, 8, 258, "Section",ExpressionUUID->"73ec55cb-5314-4876-981e-95cf93dc5c52"],
Cell[2483, 76, 3640, 109, 468, "Input",ExpressionUUID->"1163d8e6-8c6d-f043-932a-8cd79df75dac"],
Cell[6126, 187, 708, 21, 84, "Text",ExpressionUUID->"5d9fd97f-82c1-2940-8440-77adea4c40a3"],
Cell[CellGroupData[{
Cell[6859, 212, 668, 16, 194, "Input",ExpressionUUID->"3f0c3235-0883-dd4b-942b-fe864283492b"],
Cell[7530, 230, 1275, 41, 275, "Output",ExpressionUUID->"6d7295d2-bca7-4155-a57c-82fa663009c7"]
}, Open  ]],
Cell[8820, 274, 470, 7, 84, "Text",ExpressionUUID->"b3e7a6bf-26ee-ca44-9cb7-00d7dc808c87"],
Cell[CellGroupData[{
Cell[9315, 285, 541, 14, 194, "Input",ExpressionUUID->"6464d608-c2a4-a747-854b-67744a2e8591"],
Cell[9859, 301, 1414, 46, 289, "Output",ExpressionUUID->"fa2034a9-c30c-4240-a26c-e86d9ad27e21"]
}, Open  ]],
Cell[11288, 350, 714, 21, 84, "Text",ExpressionUUID->"9fb5e2b2-82b5-914f-ad87-164bba40d3c0"],
Cell[CellGroupData[{
Cell[12027, 375, 520, 14, 194, "Input",ExpressionUUID->"dd4617cc-64a7-594e-b837-70bdbfa30872"],
Cell[12550, 391, 1171, 38, 289, "Output",ExpressionUUID->"96ab0b0b-88a6-4fc4-8642-aa2193c7df26"]
}, Open  ]],
Cell[13736, 432, 397, 6, 84, "Text",ExpressionUUID->"0e4c56aa-cc25-6d4c-99af-0a898ddbfddb"],
Cell[CellGroupData[{
Cell[14158, 442, 522, 14, 194, "Input",ExpressionUUID->"71bb1fbd-99d6-7948-8291-ac0dd12c4e9e"],
Cell[14683, 458, 1183, 39, 275, "Output",ExpressionUUID->"d503245f-a9df-4685-b62e-a38827061bbb"]
}, Open  ]],
Cell[15881, 500, 442, 6, 139, "Text",ExpressionUUID->"70e1f69a-8078-1d47-9fe8-a991ce1d69cc"],
Cell[CellGroupData[{
Cell[16348, 510, 606, 15, 282, "Input",ExpressionUUID->"0335171f-82d2-a84b-ac7e-deae03f2c138"],
Cell[16957, 527, 1377, 47, 289, "Output",ExpressionUUID->"2bf632cb-fc23-445f-805d-7109fc4ad741"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18383, 580, 351, 5, 258, "Section",ExpressionUUID->"83fea3e1-6bfe-4354-a81e-9fca04922cf3"],
Cell[18737, 587, 3851, 118, 490, "Input",ExpressionUUID->"7285b796-c2d3-4e31-825c-f480b0853b2e"],
Cell[22591, 707, 703, 13, 139, "Text",ExpressionUUID->"d21a102a-0ff7-406b-b46c-a40a29f64389"],
Cell[CellGroupData[{
Cell[23319, 724, 556, 13, 105, "Input",ExpressionUUID->"864381ba-891d-46f6-b431-1f11980765a6"],
Cell[23878, 739, 1396, 48, 289, "Output",ExpressionUUID->"03de7409-04d3-48e2-a1a3-c36f64f382c1"]
}, Open  ]],
Cell[25289, 790, 890, 15, 139, "Text",ExpressionUUID->"ebfb95ff-02b1-4d1a-bd24-595c751c65bd"],
Cell[CellGroupData[{
Cell[26204, 809, 410, 9, 194, "Input",ExpressionUUID->"cbc69fa2-0209-4ade-98c6-c702564f795c"],
Cell[26617, 820, 1367, 46, 289, "Output",ExpressionUUID->"b14fd842-bf55-44ae-9968-2b97cbfc606a"]
}, Open  ]],
Cell[27999, 869, 942, 15, 139, "Text",ExpressionUUID->"856e8758-9fc8-4664-ba90-afdf43376241"],
Cell[CellGroupData[{
Cell[28966, 888, 845, 20, 194, "Input",ExpressionUUID->"0457e4ec-17da-427e-ac5c-6f64535449c8"],
Cell[29814, 910, 1549, 46, 289, "Output",ExpressionUUID->"1c0e6c62-4ade-4713-b957-3bb76c833d9d"]
}, Open  ]],
Cell[31378, 959, 828, 14, 139, "Text",ExpressionUUID->"7aaafa81-6b88-4654-a0cb-434cc9d8f263"],
Cell[CellGroupData[{
Cell[32231, 977, 785, 18, 282, "Input",ExpressionUUID->"de3ea8af-46e9-4128-a21b-359974e81ecb"],
Cell[33019, 997, 1435, 45, 289, "Output",ExpressionUUID->"8e3225fb-7024-4634-87a2-a7b482623994"]
}, Open  ]],
Cell[34469, 1045, 887, 15, 139, "Text",ExpressionUUID->"7873a8cc-88e0-4da2-9d8c-857aa4862c18"],
Cell[CellGroupData[{
Cell[35381, 1064, 546, 15, 194, "Input",ExpressionUUID->"2997752f-28e5-4b35-8332-697435c64ea2"],
Cell[35930, 1081, 1627, 47, 289, "Output",ExpressionUUID->"81f998f6-b8ae-4384-87ab-e7a516346fcb"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37606, 1134, 422, 7, 258, "Section",ExpressionUUID->"e902e0fc-987f-437c-89ef-0f1dc2931003"],
Cell[38031, 1143, 497, 10, 412, "Text",ExpressionUUID->"471bb8d7-72ba-4854-aff8-e11af3221b56"],
Cell[38531, 1155, 218, 5, 84, "Text",ExpressionUUID->"d5e1c1e8-066f-46c1-9966-9dfa5650666c"],
Cell[38752, 1162, 302, 7, 139, "Text",ExpressionUUID->"4ca8824a-3e49-4966-896f-5c63dbf27a32"],
Cell[39057, 1171, 429, 10, 357, "Text",ExpressionUUID->"687d10de-c20b-42c1-b77b-de42a37a164f"],
Cell[39489, 1183, 514, 10, 357, "Text",ExpressionUUID->"efe33d39-1b9a-43ea-89c7-098abcaf28a3"],
Cell[40006, 1195, 744, 14, 521, "Text",ExpressionUUID->"3c8bb97c-4aee-42a2-abb9-e5cb1e5f98b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40787, 1214, 318, 5, 165, "Section",ExpressionUUID->"20840740-7c18-4b82-a513-6a8f498ea7eb"],
Cell[41108, 1221, 1941, 47, 271, "Text",ExpressionUUID->"5da980da-9dff-4544-9f96-aaa3fee189d7"],
Cell[CellGroupData[{
Cell[43074, 1272, 1333, 38, 371, "Input",ExpressionUUID->"732eaa44-4a83-4722-aa51-523d9445354e"],
Cell[44410, 1312, 959, 27, 227, "Output",ExpressionUUID->"cc53bca3-8925-4fae-9780-fae92e7ac7c7"]
}, Open  ]],
Cell[45384, 1342, 2075, 51, 271, "Text",ExpressionUUID->"49c93598-0f0d-418d-acf3-9e7bb0c45398"],
Cell[CellGroupData[{
Cell[47484, 1397, 1405, 42, 371, "Input",ExpressionUUID->"b9063697-a6d5-4b41-8d4c-397bdddbd98b"],
Cell[48892, 1441, 1209, 35, 241, "Output",ExpressionUUID->"eb6458a4-6aa5-465a-8763-22e0f8ecf41e"]
}, Open  ]],
Cell[50116, 1479, 2421, 63, 321, "Text",ExpressionUUID->"1fcf9aed-24c2-4c48-a928-5d0c7501803e"],
Cell[CellGroupData[{
Cell[52562, 1546, 1695, 53, 420, "Input",ExpressionUUID->"29e8135a-6d19-43de-a566-2ffdb9c68234"],
Cell[54260, 1601, 1155, 33, 297, "Output",ExpressionUUID->"d42f917b-7f87-46a0-8ba2-9b626efce9a1"]
}, Open  ]],
Cell[55430, 1637, 2437, 64, 320, "Text",ExpressionUUID->"4e5978ed-c1d9-41cc-8a0f-617c2526453c"],
Cell[CellGroupData[{
Cell[57892, 1705, 1723, 54, 419, "Input",ExpressionUUID->"2d56d49c-5a6f-48b3-beed-672f5b003c18"],
Cell[59618, 1761, 1258, 37, 284, "Output",ExpressionUUID->"06fb4371-e105-4470-8da1-d9f6b4b32e0a"]
}, Open  ]],
Cell[60891, 1801, 2577, 69, 383, "Text",ExpressionUUID->"8afcff4f-0e42-422d-aac2-65b3b6bda310"],
Cell[CellGroupData[{
Cell[63493, 1874, 1869, 59, 487, "Input",ExpressionUUID->"110e99f3-3956-4855-a86f-c407bd3e0422"],
Cell[65365, 1935, 1108, 30, 354, "Output",ExpressionUUID->"4895b902-2c9d-4156-a690-938a18cdfe86"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66522, 1971, 352, 5, 258, "Section",ExpressionUUID->"5ce77ced-8f4b-4e2e-8bc3-a5e83e35c495"],
Cell[66877, 1978, 1859, 44, 220, "Text",ExpressionUUID->"3fb84f8a-11b0-43ce-898e-659b85b560fa"],
Cell[CellGroupData[{
Cell[68761, 2026, 1026, 30, 222, "Input",ExpressionUUID->"0e6b07c0-291e-4ac1-80f2-8509692dabf7"],
Cell[69790, 2058, 1307, 43, 288, "Output",ExpressionUUID->"cccaaf1f-da61-46c3-9d90-65a95b90b2bf"]
}, Open  ]],
Cell[71112, 2104, 1816, 42, 220, "Text",ExpressionUUID->"9be1c3cb-0714-4f27-b260-4c1a6c181dde"],
Cell[CellGroupData[{
Cell[72953, 2150, 900, 26, 222, "Input",ExpressionUUID->"ccb298da-8f20-4f75-b5b3-218dc76bd524"],
Cell[73856, 2178, 1100, 37, 289, "Output",ExpressionUUID->"4e95de18-1c57-4bcb-9f1a-d44577cd56bb"]
}, Open  ]],
Cell[74971, 2218, 1738, 39, 245, "Text",ExpressionUUID->"7b921e29-b0f3-4adf-b9e0-6dd83174ddab"],
Cell[CellGroupData[{
Cell[76734, 2261, 819, 23, 259, "Input",ExpressionUUID->"5d9b9177-1b62-47b3-a98b-a6048bb0fcaf"],
Cell[77556, 2286, 1352, 46, 289, "Output",ExpressionUUID->"735ff458-62f1-4ad9-9698-35f5c4587f45"]
}, Open  ]],
Cell[78923, 2335, 1937, 47, 245, "Text",ExpressionUUID->"cdc10fd9-1e0d-4e04-b0a9-af68d85e8e72"],
Cell[CellGroupData[{
Cell[80885, 2386, 1055, 32, 259, "Input",ExpressionUUID->"ccb658af-ebef-4eb2-a73b-e584529653c4"],
Cell[81943, 2420, 1248, 43, 289, "Output",ExpressionUUID->"201056eb-b5ef-4569-9d00-e31344424030"]
}, Open  ]],
Cell[83206, 2466, 2171, 56, 332, "Text",ExpressionUUID->"10dddb71-6375-4f16-919d-c7872d3fc7d4"],
Cell[CellGroupData[{
Cell[85402, 2526, 1325, 41, 357, "Input",ExpressionUUID->"42646ab5-5c26-43c1-898b-e7a8d25c1cfb"],
Cell[86730, 2569, 1883, 60, 346, "Output",ExpressionUUID->"27fee49e-8152-453b-b57c-1c47f993afa4"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[88662, 2635, 392, 6, 165, "Section",ExpressionUUID->"cc17a8a9-8f7e-4c16-9898-c9fd826208ba"],
Cell[89057, 2643, 1938, 43, 171, "Text",ExpressionUUID->"40db02dd-d165-4dc7-913a-979bf33e3770"],
Cell[CellGroupData[{
Cell[91020, 2690, 869, 26, 179, "Input",ExpressionUUID->"a14575ef-681d-41f1-962e-8286748a6cd6"],
Cell[91892, 2718, 171, 2, 83, "Output",ExpressionUUID->"cd37a008-88ac-4387-9ccf-ea597231271b"]
}, Open  ]],
Cell[92078, 2723, 2048, 46, 196, "Text",ExpressionUUID->"fe441283-d038-49b6-acb3-878121acd77e"],
Cell[CellGroupData[{
Cell[94151, 2773, 792, 23, 217, "Input",ExpressionUUID->"3107df38-d85e-4b88-975a-fb972e49b401"],
Cell[94946, 2798, 170, 3, 104, "Output",ExpressionUUID->"9a6d16f1-0332-430c-989e-a475964f6da4"]
}, Open  ]],
Cell[95131, 2804, 2033, 45, 208, "Text",ExpressionUUID->"3db56c58-a488-4229-a51c-fb63d3989ef1"],
Cell[CellGroupData[{
Cell[97189, 2853, 864, 26, 235, "Input",ExpressionUUID->"fe95656c-1f56-48d3-9278-a5158f3ce1c1"],
Cell[98056, 2881, 191, 4, 104, "Output",ExpressionUUID->"cbb33c1b-318e-43a9-8f32-ecff5e4918a9"]
}, Open  ]],
Cell[98262, 2888, 2289, 54, 258, "Text",ExpressionUUID->"9fd5f8da-e3ed-41d4-b1fc-a741b61ff560"],
Cell[CellGroupData[{
Cell[100576, 2946, 1091, 35, 277, "Input",ExpressionUUID->"e0e0e209-d049-4e70-b57d-56749875905c"],
Cell[101670, 2983, 176, 4, 104, "Output",ExpressionUUID->"13399c64-f8e6-4697-8144-d9ee3dbceecd"]
}, Open  ]],
Cell[101861, 2990, 2210, 50, 308, "Text",ExpressionUUID->"738dea23-4b81-411d-b146-f3eb44bc69a6"],
Cell[CellGroupData[{
Cell[104096, 3044, 1019, 31, 320, "Input",ExpressionUUID->"e1236856-96f6-449e-a766-41aab5dcba01"],
Cell[105118, 3077, 177, 4, 104, "Output",ExpressionUUID->"0d86865d-f1d2-4e82-bad3-d5b4cbf06937"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[105344, 3087, 397, 6, 258, "Section",ExpressionUUID->"adf13ff3-b331-433f-8659-5f26f1afb197"],
Cell[105744, 3095, 1947, 45, 208, "Text",ExpressionUUID->"14451dd8-a6ff-4ce6-b13f-d2d1a5227257"],
Cell[CellGroupData[{
Cell[107716, 3144, 924, 28, 235, "Input",ExpressionUUID->"2cfa50dd-d0b9-4c62-b7d3-7e90430c52fd"],
Cell[108643, 3174, 191, 4, 104, "Output",ExpressionUUID->"83db462b-b24f-429d-af2e-a41446f65a4b"]
}, Open  ]],
Cell[108849, 3181, 1950, 45, 208, "Text",ExpressionUUID->"359f407b-f1d3-49a7-acde-3c7c4a278d2e"],
Cell[CellGroupData[{
Cell[110824, 3230, 904, 27, 235, "Input",ExpressionUUID->"a50c9ff4-d106-4dfb-be43-068c72896291"],
Cell[111731, 3259, 191, 4, 104, "Output",ExpressionUUID->"fb10c480-8c6f-49dd-b2b7-5d99e9bce390"]
}, Open  ]],
Cell[111937, 3266, 1972, 45, 208, "Text",ExpressionUUID->"f03f893b-29c9-41dc-89c5-00dee92b53de"],
Cell[CellGroupData[{
Cell[113934, 3315, 899, 27, 235, "Input",ExpressionUUID->"50cba0b9-f089-44c8-b4c9-ddc431ec2d87"],
Cell[114836, 3344, 191, 4, 104, "Output",ExpressionUUID->"e1fe9571-7b88-4c62-a507-dee6c772f861"]
}, Open  ]],
Cell[115042, 3351, 2062, 48, 233, "Text",ExpressionUUID->"f6aea2b3-3a3e-4dc0-b922-53600fe9651a"],
Cell[CellGroupData[{
Cell[117129, 3403, 963, 29, 240, "Input",ExpressionUUID->"f5a9ccc3-8c48-4049-8d3d-9db8f2469e0c"],
Cell[118095, 3434, 190, 4, 104, "Output",ExpressionUUID->"d0c50ec1-57c6-4499-b94a-c220e7fea80d"]
}, Open  ]],
Cell[118300, 3441, 2438, 62, 321, "Text",ExpressionUUID->"c1a711e5-a6bd-4d54-a56f-302274ba2862"],
Cell[CellGroupData[{
Cell[120763, 3507, 1343, 43, 339, "Input",ExpressionUUID->"c76bd92d-2674-4a95-a64e-aafaec2bfb87"],
Cell[122109, 3552, 175, 3, 104, "Output",ExpressionUUID->"216d3515-2bbb-4b68-8eae-0b71cc304808"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[122333, 3561, 336, 5, 165, "Section",ExpressionUUID->"dd427e0d-7505-4f18-8d63-d88a709b32df"],
Cell[122672, 3568, 1984, 45, 196, "Text",ExpressionUUID->"987121bb-4c03-43b7-a20d-ce10f23f7b64"],
Cell[CellGroupData[{
Cell[124681, 3617, 1332, 42, 216, "Input",ExpressionUUID->"74c11ab6-c4d9-45eb-875d-86d1877e8d53"],
Cell[126016, 3661, 426, 14, 104, "Output",ExpressionUUID->"13e8c9ca-3afa-46ca-97f2-844c36a4c64a"]
}, Open  ]],
Cell[126457, 3678, 2056, 47, 183, "Text",ExpressionUUID->"0facd949-fb97-4996-8b86-23f6dedc557b"],
Cell[CellGroupData[{
Cell[128538, 3729, 1358, 43, 198, "Input",ExpressionUUID->"f9d0aa3a-ee95-43b4-8386-6c635d6765a8"],
Cell[129899, 3774, 397, 13, 104, "Output",ExpressionUUID->"e9542b01-c205-4f2a-a852-d712a7e2ac2c"]
}, Open  ]],
Cell[130311, 3790, 2062, 47, 208, "Text",ExpressionUUID->"b7a9c1ae-e807-4ef7-9711-acd158a91620"],
Cell[CellGroupData[{
Cell[132398, 3841, 1333, 42, 216, "Input",ExpressionUUID->"99c6cbcb-1de7-41d3-b96a-09ea55fa1759"],
Cell[133734, 3885, 394, 13, 104, "Output",ExpressionUUID->"e5d123a6-8715-48fe-a88e-38ff01072a56"]
}, Open  ]],
Cell[134143, 3901, 2264, 54, 257, "Text",ExpressionUUID->"7bd38838-49a2-4ee3-a6af-db9dec97ce97"],
Cell[CellGroupData[{
Cell[136432, 3959, 1547, 50, 277, "Input",ExpressionUUID->"bec9fe43-a0ef-4294-a203-ad45ba139831"],
Cell[137982, 4011, 448, 14, 104, "Output",ExpressionUUID->"c8d3b156-a473-4e86-b9e4-f683fb221607"]
}, Open  ]],
Cell[138445, 4028, 2308, 56, 270, "Text",ExpressionUUID->"c4696c1b-ba43-496e-9061-e0a3f38bbdf1"],
Cell[CellGroupData[{
Cell[140778, 4088, 1597, 52, 277, "Input",ExpressionUUID->"631044c1-63a6-4467-8299-2b2aba8c9447"],
Cell[142378, 4142, 492, 16, 104, "Output",ExpressionUUID->"eb37c640-5788-4906-b6d8-3b5203f86416"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[142919, 4164, 326, 5, 165, "Section",ExpressionUUID->"e84e0b9f-175f-4f33-a576-619df22977c4"],
Cell[143248, 4171, 1514, 27, 171, "Text",ExpressionUUID->"8aa888f1-d78c-4e6a-a04e-79f54f6ac1c1"],
Cell[CellGroupData[{
Cell[144787, 4202, 501, 14, 179, "Input",ExpressionUUID->"69a84945-bc16-4020-aff6-7add6fe1fc7d"],
Cell[145291, 4218, 274, 7, 83, "Output",ExpressionUUID->"92d6eec6-c7f5-4184-94d1-a244bc78fb0e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[145602, 4230, 474, 13, 179, "Input",ExpressionUUID->"19c613bf-4dd1-44a7-ab3e-e2df9542d005"],
Cell[146079, 4245, 734, 22, 192, "Output",ExpressionUUID->"95b03527-067e-43d4-b718-a5773dca59ca"]
}, Open  ]],
Cell[146828, 4270, 1565, 29, 171, "Text",ExpressionUUID->"8bd25e6b-4ff6-4310-abbf-93fedfd1a6fd"],
Cell[CellGroupData[{
Cell[148418, 4303, 550, 15, 179, "Input",ExpressionUUID->"7ce457a1-35ac-4cc4-b9e0-8a94c38cae7e"],
Cell[148971, 4320, 2899, 62, 89, "Output",ExpressionUUID->"e89aef64-0798-4469-a480-f7764a2cd638"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151907, 4387, 427, 13, 179, "Input",ExpressionUUID->"5fe2b690-a5a6-4ca2-bf93-5ce1466c645b"],
Cell[152337, 4402, 468, 12, 83, "Output",ExpressionUUID->"e1fc3b13-a0fe-46c2-9dc2-a0649c6ec9ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152842, 4419, 1361, 32, 179, "Input",ExpressionUUID->"6a6773f3-b4a7-48be-aca7-d18d7af74108"],
Cell[154206, 4453, 4590, 103, 268, "Output",ExpressionUUID->"81948c6a-a153-4de5-9d66-4870df3dc1f8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158833, 4561, 1315, 31, 179, "Input",ExpressionUUID->"d8353be2-977b-462a-82aa-73b42333cf8f"],
Cell[160151, 4594, 4625, 103, 268, "Output",ExpressionUUID->"906cb22f-c8da-4917-b203-303793483d66"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164813, 4702, 1318, 31, 179, "Input",ExpressionUUID->"e55c2dc3-0b15-4b36-b8ca-dfff11177717"],
Cell[166134, 4735, 4629, 103, 268, "Output",ExpressionUUID->"8a10a728-c3f5-4b05-9781-3da251b98a8d"]
}, Open  ]],
Cell[170778, 4841, 1544, 28, 171, "Text",ExpressionUUID->"a24545b1-23f3-476e-b638-afa1096ff4b0"],
Cell[CellGroupData[{
Cell[172347, 4873, 533, 15, 179, "Input",ExpressionUUID->"9224dc90-15f2-4467-9ba3-a44f44433ce3"],
Cell[172883, 4890, 243, 6, 83, "Output",ExpressionUUID->"d691437c-4c80-4d10-872b-b622f1dd3868"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173163, 4901, 268, 8, 179, "Input",ExpressionUUID->"c9430741-0bc3-4be2-9c87-36078896e6b3"],
Cell[173434, 4911, 177, 3, 83, "Output",ExpressionUUID->"f78e9573-ef7c-4eff-84d2-b38d916236ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[173648, 4919, 418, 11, 179, "Input",ExpressionUUID->"ccb1465b-f749-4887-9c70-25042c41a263"],
Cell[174069, 4932, 1191, 40, 220, "Output",ExpressionUUID->"53bec579-bee0-4139-bf46-a4858f1279d6"]
}, Open  ]],
Cell[175275, 4975, 1522, 28, 220, "Text",ExpressionUUID->"2d487a37-6b54-4cb4-9047-c4d5ac1d8def"],
Cell[CellGroupData[{
Cell[176822, 5007, 555, 15, 222, "Input",ExpressionUUID->"f3c0b1b6-02fd-49a1-9d86-894c76411cdc"],
Cell[177380, 5024, 331, 10, 83, "Output",ExpressionUUID->"b7ae9ab1-293d-4e88-aba7-1940b9f3b301"]
}, Open  ]],
Cell[CellGroupData[{
Cell[177748, 5039, 572, 15, 222, "Input",ExpressionUUID->"fec3e112-e67e-44dd-ba7b-65a56301412e"],
Cell[178323, 5056, 783, 24, 235, "Output",ExpressionUUID->"c66f0354-a5f4-4c25-a39c-23658745ba4c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179143, 5085, 479, 13, 222, "Input",ExpressionUUID->"cec709e2-c42b-443a-b933-d4242739a7bd"],
Cell[179625, 5100, 835, 26, 274, "Output",ExpressionUUID->"ea966651-dfdb-4550-a9b5-2509db5c03c4"]
}, Open  ]],
Cell[180475, 5129, 1689, 35, 220, "Text",ExpressionUUID->"cf31c79d-c443-4d52-9333-317fa066321c"],
Cell[CellGroupData[{
Cell[182189, 5168, 785, 23, 222, "Input",ExpressionUUID->"e753c1d9-9eb3-4aba-8d01-cf8390cf405e"],
Cell[182977, 5193, 2272, 51, 89, "Output",ExpressionUUID->"d2243742-b577-4519-99bb-49a60d5b7839"]
}, Open  ]],
Cell[CellGroupData[{
Cell[185286, 5249, 660, 21, 222, "Input",ExpressionUUID->"4085b57e-bd0d-432c-aea3-9d67e89d59bc"],
Cell[185949, 5272, 384, 11, 109, "Output",ExpressionUUID->"ea88e2ac-990f-4898-91f5-14fa395a012c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[186370, 5288, 1726, 43, 325, "Input",ExpressionUUID->"69f04cc7-4c49-403d-87b3-ca09bc6e7a36"],
Cell[188099, 5333, 14308, 301, 349, "Output",ExpressionUUID->"681a0c30-0969-4fd2-8161-610a5deacec3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[202444, 5639, 1678, 42, 325, "Input",ExpressionUUID->"11095802-198d-4163-9fb2-3b45626aa205"],
Cell[204125, 5683, 14310, 301, 349, "Output",ExpressionUUID->"3cca7844-913f-4c4b-9f54-828bfc9e6e5d"]
}, Open  ]]
}, Open  ]]
}
]
*)

